package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.TestSuite;

@JsonIgnoreType
public class TestSuiteRequest extends EntityRequest<TestSuite> {

    public TestSuiteRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestSuite.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public WorkItemRequest testSuiteWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TestSuiteWorkItem"), Optional.empty());
    }

    public WorkItemRequest testPlanWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TestPlanWorkItem"), Optional.empty());
    }

    public WorkItemRequest requirementWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("RequirementWorkItem"), Optional.empty());
    }

}
