package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.TestResult;

@JsonIgnoreType
public class TestResultRequest extends EntityRequest<TestResult> {

    public TestResultRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestResult.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public TestRunRequest testRun() {
        return new TestRunRequest(contextPath.addSegment("TestRun"), Optional.empty());
    }

    public TestRequest test() {
        return new TestRequest(contextPath.addSegment("Test"), Optional.empty());
    }

    public PipelineRunRequest pipelineRun() {
        return new PipelineRunRequest(contextPath.addSegment("PipelineRun"), Optional.empty());
    }

    public PipelineRequest pipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), Optional.empty());
    }

    public BranchRequest branch() {
        return new BranchRequest(contextPath.addSegment("Branch"), Optional.empty());
    }

    public CalendarDateRequest completedOn() {
        return new CalendarDateRequest(contextPath.addSegment("CompletedOn"), Optional.empty());
    }

    public CalendarDateRequest startedOn() {
        return new CalendarDateRequest(contextPath.addSegment("StartedOn"), Optional.empty());
    }

}
