package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.Team;
import microsoft.vs.analytics.v4.model.entity.collection.request.AreaCollectionRequest;
import microsoft.vs.analytics.v4.model.entity.collection.request.IterationCollectionRequest;

@JsonIgnoreType
public class TeamRequest extends EntityRequest<Team> {

    public TeamRequest(ContextPath contextPath, Optional<Object> value) {
        super(Team.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public AreaCollectionRequest areas() {
        return new AreaCollectionRequest(
                        contextPath.addSegment("Areas"), Optional.empty());
    }

    public AreaRequest areas(String areaSK) {
        return new AreaRequest(contextPath.addSegment("Areas").addKeys(new NameValue(areaSK.toString())), Optional.empty());
    }

    public IterationCollectionRequest iterations() {
        return new IterationCollectionRequest(
                        contextPath.addSegment("Iterations"), Optional.empty());
    }

    public IterationRequest iterations(String iterationSK) {
        return new IterationRequest(contextPath.addSegment("Iterations").addKeys(new NameValue(iterationSK.toString())), Optional.empty());
    }

}
