package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.PipelineTask;

@JsonIgnoreType
public class PipelineTaskRequest extends EntityRequest<PipelineTask> {

    public PipelineTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(PipelineTask.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

}
