package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.PipelineRunActivityResult;

@JsonIgnoreType
public class PipelineRunActivityResultRequest extends EntityRequest<PipelineRunActivityResult> {

    public PipelineRunActivityResultRequest(ContextPath contextPath, Optional<Object> value) {
        super(PipelineRunActivityResult.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public PipelineRequest pipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), Optional.empty());
    }

    public PipelineTaskRequest pipelineTask() {
        return new PipelineTaskRequest(contextPath.addSegment("PipelineTask"), Optional.empty());
    }

    public PipelineJobRequest pipelineJob() {
        return new PipelineJobRequest(contextPath.addSegment("PipelineJob"), Optional.empty());
    }

    public BranchRequest branch() {
        return new BranchRequest(contextPath.addSegment("Branch"), Optional.empty());
    }

    public CalendarDateRequest pipelineRunQueuedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunQueuedOn"), Optional.empty());
    }

    public CalendarDateRequest pipelineRunStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunStartedOn"), Optional.empty());
    }

    public CalendarDateRequest pipelineRunCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunCompletedOn"), Optional.empty());
    }

    public CalendarDateRequest activityStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ActivityStartedOn"), Optional.empty());
    }

    public CalendarDateRequest activityCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ActivityCompletedOn"), Optional.empty());
    }

}
