package microsoft.vs.analytics.v4.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.BoardLocation;
import microsoft.vs.analytics.v4.model.entity.collection.request.WorkItemCollectionRequest;

@JsonIgnoreType
public class BoardLocationRequest extends EntityRequest<BoardLocation> {

    public BoardLocationRequest(ContextPath contextPath, Optional<Object> value) {
        super(BoardLocation.class, contextPath, value, false);
    }

    public TeamRequest team() {
        return new TeamRequest(contextPath.addSegment("Team"), Optional.empty());
    }

    public WorkItemCollectionRequest workItems() {
        return new WorkItemCollectionRequest(
                        contextPath.addSegment("WorkItems"), Optional.empty());
    }

    public WorkItemRequest workItems(Integer workItemId) {
        return new WorkItemRequest(contextPath.addSegment("WorkItems").addKeys(new NameValue(workItemId.toString())), Optional.empty());
    }

}
