package microsoft.vs.analytics.v4.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.WorkItemSnapshot;
import microsoft.vs.analytics.v4.model.entity.request.ProcessRequest;
import microsoft.vs.analytics.v4.model.entity.request.TagRequest;
import microsoft.vs.analytics.v4.model.entity.request.TeamRequest;
import microsoft.vs.analytics.v4.model.entity.request.WorkItemSnapshotRequest;

public class WorkItemSnapshotCollectionRequest extends CollectionPageEntityRequest<WorkItemSnapshot, WorkItemSnapshotRequest>{

    protected ContextPath contextPath;

    public WorkItemSnapshotCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkItemSnapshot.class, cp -> new WorkItemSnapshotRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

    public ProcessCollectionRequest processes() {
        return new ProcessCollectionRequest(contextPath.addSegment("Processes"), Optional.empty());
    }

    public ProcessRequest processes(Integer processSK) {
        return new ProcessRequest(contextPath.addSegment("Processes").addKeys(new NameValue(processSK.toString())), Optional.empty());
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(contextPath.addSegment("Tags"), Optional.empty());
    }

    public TagRequest tags(Integer tagSK) {
        return new TagRequest(contextPath.addSegment("Tags").addKeys(new NameValue(tagSK.toString())), Optional.empty());
    }

}
