package microsoft.vs.analytics.v4.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.WorkItemLink;
import microsoft.vs.analytics.v4.model.entity.request.WorkItemLinkRequest;

public class WorkItemLinkCollectionRequest extends CollectionPageEntityRequest<WorkItemLink, WorkItemLinkRequest>{

    protected ContextPath contextPath;

    public WorkItemLinkCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkItemLink.class, cp -> new WorkItemLinkRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
