package microsoft.vs.analytics.v4.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.Iteration;
import microsoft.vs.analytics.v4.model.entity.request.IterationRequest;
import microsoft.vs.analytics.v4.model.entity.request.TeamRequest;

public class IterationCollectionRequest extends CollectionPageEntityRequest<Iteration, IterationRequest>{

    protected ContextPath contextPath;

    public IterationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Iteration.class, cp -> new IterationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

}
