package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.enums.UserType;

@JsonPropertyOrder({
    "@odata.type", 
    "UserSK", 
    "UserId", 
    "UserName", 
    "UserEmail", 
    "AnalyticsUpdatedDate", 
    "GitHubUserId", 
    "UserType"})
@JsonInclude(Include.NON_NULL)
public class User implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.User";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("UserSK")
    protected String userSK;

    @JsonProperty("UserId")
    protected String userId;

    @JsonProperty("UserName")
    protected String userName;

    @JsonProperty("UserEmail")
    protected String userEmail;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("GitHubUserId")
    protected String gitHubUserId;

    @JsonProperty("UserType")
    protected UserType userType;

    protected User() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String userSK;
        private String userId;
        private String userName;
        private String userEmail;
        private OffsetDateTime analyticsUpdatedDate;
        private String gitHubUserId;
        private UserType userType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder userSK(String userSK) {
            this.userSK = userSK;
            this.changedFields = changedFields.add("UserSK");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("UserId");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("UserName");
            return this;
        }

        public Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            this.changedFields = changedFields.add("UserEmail");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder gitHubUserId(String gitHubUserId) {
            this.gitHubUserId = gitHubUserId;
            this.changedFields = changedFields.add("GitHubUserId");
            return this;
        }

        public Builder userType(UserType userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("UserType");
            return this;
        }

        public User build() {
            User _x = new User();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.User";
            _x.userSK = userSK;
            _x.userId = userId;
            _x.userName = userName;
            _x.userEmail = userEmail;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.gitHubUserId = gitHubUserId;
            _x.userType = userType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userSK.toString()));
        }
    }

    @Property(name="UserSK")
    @JsonIgnore
    public Optional<String> getUserSK() {
        return Optional.ofNullable(userSK);
    }

    public User withUserSK(String userSK) {
        User _x = _copy();
        _x.changedFields = changedFields.add("UserSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.userSK = userSK;
        return _x;
    }

    @Property(name="UserId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public User withUserId(String userId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("UserId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.userId = userId;
        return _x;
    }

    @Property(name="UserName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    public User withUserName(String userName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("UserName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.userName = userName;
        return _x;
    }

    @Property(name="UserEmail")
    @JsonIgnore
    public Optional<String> getUserEmail() {
        return Optional.ofNullable(userEmail);
    }

    public User withUserEmail(String userEmail) {
        User _x = _copy();
        _x.changedFields = changedFields.add("UserEmail");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.userEmail = userEmail;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public User withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        User _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="GitHubUserId")
    @JsonIgnore
    public Optional<String> getGitHubUserId() {
        return Optional.ofNullable(gitHubUserId);
    }

    public User withGitHubUserId(String gitHubUserId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("GitHubUserId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.gitHubUserId = gitHubUserId;
        return _x;
    }

    @Property(name="UserType")
    @JsonIgnore
    public Optional<UserType> getUserType() {
        return Optional.ofNullable(userType);
    }

    public User withUserType(UserType userType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("UserType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.User");
        _x.userType = userType;
        return _x;
    }

    public User withUnmappedField(String name, String value) {
        User _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private User _copy() {
        User _x = new User();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.userSK = userSK;
        _x.userId = userId;
        _x.userName = userName;
        _x.userEmail = userEmail;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.gitHubUserId = gitHubUserId;
        _x.userType = userType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("User[");
        b.append("UserSK=");
        b.append(this.userSK);
        b.append(", ");
        b.append("UserId=");
        b.append(this.userId);
        b.append(", ");
        b.append("UserName=");
        b.append(this.userName);
        b.append(", ");
        b.append("UserEmail=");
        b.append(this.userEmail);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("GitHubUserId=");
        b.append(this.gitHubUserId);
        b.append(", ");
        b.append("UserType=");
        b.append(this.userType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
