package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.edm.UnsignedByte;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v4.model.entity.request.WorkItemRequest;
import microsoft.vs.analytics.v4.model.enums.TestSuiteType;

@JsonPropertyOrder({
    "@odata.type", 
    "AnalyticsUpdatedDate", 
    "ProjectSK", 
    "TestSuiteSK", 
    "TestPlanId", 
    "TestSuiteId", 
    "TestPlanTitle", 
    "Title", 
    "OrderId", 
    "IdLevel1", 
    "TitleLevel1", 
    "IdLevel2", 
    "TitleLevel2", 
    "IdLevel3", 
    "TitleLevel3", 
    "IdLevel4", 
    "TitleLevel4", 
    "IdLevel5", 
    "TitleLevel5", 
    "IdLevel6", 
    "TitleLevel6", 
    "IdLevel7", 
    "TitleLevel7", 
    "IdLevel8", 
    "TitleLevel8", 
    "IdLevel9", 
    "TitleLevel9", 
    "IdLevel10", 
    "TitleLevel10", 
    "IdLevel11", 
    "TitleLevel11", 
    "IdLevel12", 
    "TitleLevel12", 
    "IdLevel13", 
    "TitleLevel13", 
    "IdLevel14", 
    "TitleLevel14", 
    "Depth", 
    "Type", 
    "RequirementWorkItemId"})
@JsonInclude(Include.NON_NULL)
public class TestSuite implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestSuiteSK")
    protected Integer testSuiteSK;

    @JsonProperty("TestPlanId")
    protected Integer testPlanId;

    @JsonProperty("TestSuiteId")
    protected Integer testSuiteId;

    @JsonProperty("TestPlanTitle")
    protected String testPlanTitle;

    @JsonProperty("Title")
    protected String title;

    @JsonProperty("OrderId")
    protected Integer orderId;

    @JsonProperty("IdLevel1")
    protected Integer idLevel1;

    @JsonProperty("TitleLevel1")
    protected String titleLevel1;

    @JsonProperty("IdLevel2")
    protected Integer idLevel2;

    @JsonProperty("TitleLevel2")
    protected String titleLevel2;

    @JsonProperty("IdLevel3")
    protected Integer idLevel3;

    @JsonProperty("TitleLevel3")
    protected String titleLevel3;

    @JsonProperty("IdLevel4")
    protected Integer idLevel4;

    @JsonProperty("TitleLevel4")
    protected String titleLevel4;

    @JsonProperty("IdLevel5")
    protected Integer idLevel5;

    @JsonProperty("TitleLevel5")
    protected String titleLevel5;

    @JsonProperty("IdLevel6")
    protected Integer idLevel6;

    @JsonProperty("TitleLevel6")
    protected String titleLevel6;

    @JsonProperty("IdLevel7")
    protected Integer idLevel7;

    @JsonProperty("TitleLevel7")
    protected String titleLevel7;

    @JsonProperty("IdLevel8")
    protected Integer idLevel8;

    @JsonProperty("TitleLevel8")
    protected String titleLevel8;

    @JsonProperty("IdLevel9")
    protected Integer idLevel9;

    @JsonProperty("TitleLevel9")
    protected String titleLevel9;

    @JsonProperty("IdLevel10")
    protected Integer idLevel10;

    @JsonProperty("TitleLevel10")
    protected String titleLevel10;

    @JsonProperty("IdLevel11")
    protected Integer idLevel11;

    @JsonProperty("TitleLevel11")
    protected String titleLevel11;

    @JsonProperty("IdLevel12")
    protected Integer idLevel12;

    @JsonProperty("TitleLevel12")
    protected String titleLevel12;

    @JsonProperty("IdLevel13")
    protected Integer idLevel13;

    @JsonProperty("TitleLevel13")
    protected String titleLevel13;

    @JsonProperty("IdLevel14")
    protected Integer idLevel14;

    @JsonProperty("TitleLevel14")
    protected String titleLevel14;

    @JsonProperty("Depth")
    protected UnsignedByte depth;

    @JsonProperty("Type")
    protected TestSuiteType type;

    @JsonProperty("RequirementWorkItemId")
    protected Integer requirementWorkItemId;

    protected TestSuite() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime analyticsUpdatedDate;
        private String projectSK;
        private Integer testSuiteSK;
        private Integer testPlanId;
        private Integer testSuiteId;
        private String testPlanTitle;
        private String title;
        private Integer orderId;
        private Integer idLevel1;
        private String titleLevel1;
        private Integer idLevel2;
        private String titleLevel2;
        private Integer idLevel3;
        private String titleLevel3;
        private Integer idLevel4;
        private String titleLevel4;
        private Integer idLevel5;
        private String titleLevel5;
        private Integer idLevel6;
        private String titleLevel6;
        private Integer idLevel7;
        private String titleLevel7;
        private Integer idLevel8;
        private String titleLevel8;
        private Integer idLevel9;
        private String titleLevel9;
        private Integer idLevel10;
        private String titleLevel10;
        private Integer idLevel11;
        private String titleLevel11;
        private Integer idLevel12;
        private String titleLevel12;
        private Integer idLevel13;
        private String titleLevel13;
        private Integer idLevel14;
        private String titleLevel14;
        private UnsignedByte depth;
        private TestSuiteType type;
        private Integer requirementWorkItemId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testSuiteSK(Integer testSuiteSK) {
            this.testSuiteSK = testSuiteSK;
            this.changedFields = changedFields.add("TestSuiteSK");
            return this;
        }

        public Builder testPlanId(Integer testPlanId) {
            this.testPlanId = testPlanId;
            this.changedFields = changedFields.add("TestPlanId");
            return this;
        }

        public Builder testSuiteId(Integer testSuiteId) {
            this.testSuiteId = testSuiteId;
            this.changedFields = changedFields.add("TestSuiteId");
            return this;
        }

        public Builder testPlanTitle(String testPlanTitle) {
            this.testPlanTitle = testPlanTitle;
            this.changedFields = changedFields.add("TestPlanTitle");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("Title");
            return this;
        }

        public Builder orderId(Integer orderId) {
            this.orderId = orderId;
            this.changedFields = changedFields.add("OrderId");
            return this;
        }

        public Builder idLevel1(Integer idLevel1) {
            this.idLevel1 = idLevel1;
            this.changedFields = changedFields.add("IdLevel1");
            return this;
        }

        public Builder titleLevel1(String titleLevel1) {
            this.titleLevel1 = titleLevel1;
            this.changedFields = changedFields.add("TitleLevel1");
            return this;
        }

        public Builder idLevel2(Integer idLevel2) {
            this.idLevel2 = idLevel2;
            this.changedFields = changedFields.add("IdLevel2");
            return this;
        }

        public Builder titleLevel2(String titleLevel2) {
            this.titleLevel2 = titleLevel2;
            this.changedFields = changedFields.add("TitleLevel2");
            return this;
        }

        public Builder idLevel3(Integer idLevel3) {
            this.idLevel3 = idLevel3;
            this.changedFields = changedFields.add("IdLevel3");
            return this;
        }

        public Builder titleLevel3(String titleLevel3) {
            this.titleLevel3 = titleLevel3;
            this.changedFields = changedFields.add("TitleLevel3");
            return this;
        }

        public Builder idLevel4(Integer idLevel4) {
            this.idLevel4 = idLevel4;
            this.changedFields = changedFields.add("IdLevel4");
            return this;
        }

        public Builder titleLevel4(String titleLevel4) {
            this.titleLevel4 = titleLevel4;
            this.changedFields = changedFields.add("TitleLevel4");
            return this;
        }

        public Builder idLevel5(Integer idLevel5) {
            this.idLevel5 = idLevel5;
            this.changedFields = changedFields.add("IdLevel5");
            return this;
        }

        public Builder titleLevel5(String titleLevel5) {
            this.titleLevel5 = titleLevel5;
            this.changedFields = changedFields.add("TitleLevel5");
            return this;
        }

        public Builder idLevel6(Integer idLevel6) {
            this.idLevel6 = idLevel6;
            this.changedFields = changedFields.add("IdLevel6");
            return this;
        }

        public Builder titleLevel6(String titleLevel6) {
            this.titleLevel6 = titleLevel6;
            this.changedFields = changedFields.add("TitleLevel6");
            return this;
        }

        public Builder idLevel7(Integer idLevel7) {
            this.idLevel7 = idLevel7;
            this.changedFields = changedFields.add("IdLevel7");
            return this;
        }

        public Builder titleLevel7(String titleLevel7) {
            this.titleLevel7 = titleLevel7;
            this.changedFields = changedFields.add("TitleLevel7");
            return this;
        }

        public Builder idLevel8(Integer idLevel8) {
            this.idLevel8 = idLevel8;
            this.changedFields = changedFields.add("IdLevel8");
            return this;
        }

        public Builder titleLevel8(String titleLevel8) {
            this.titleLevel8 = titleLevel8;
            this.changedFields = changedFields.add("TitleLevel8");
            return this;
        }

        public Builder idLevel9(Integer idLevel9) {
            this.idLevel9 = idLevel9;
            this.changedFields = changedFields.add("IdLevel9");
            return this;
        }

        public Builder titleLevel9(String titleLevel9) {
            this.titleLevel9 = titleLevel9;
            this.changedFields = changedFields.add("TitleLevel9");
            return this;
        }

        public Builder idLevel10(Integer idLevel10) {
            this.idLevel10 = idLevel10;
            this.changedFields = changedFields.add("IdLevel10");
            return this;
        }

        public Builder titleLevel10(String titleLevel10) {
            this.titleLevel10 = titleLevel10;
            this.changedFields = changedFields.add("TitleLevel10");
            return this;
        }

        public Builder idLevel11(Integer idLevel11) {
            this.idLevel11 = idLevel11;
            this.changedFields = changedFields.add("IdLevel11");
            return this;
        }

        public Builder titleLevel11(String titleLevel11) {
            this.titleLevel11 = titleLevel11;
            this.changedFields = changedFields.add("TitleLevel11");
            return this;
        }

        public Builder idLevel12(Integer idLevel12) {
            this.idLevel12 = idLevel12;
            this.changedFields = changedFields.add("IdLevel12");
            return this;
        }

        public Builder titleLevel12(String titleLevel12) {
            this.titleLevel12 = titleLevel12;
            this.changedFields = changedFields.add("TitleLevel12");
            return this;
        }

        public Builder idLevel13(Integer idLevel13) {
            this.idLevel13 = idLevel13;
            this.changedFields = changedFields.add("IdLevel13");
            return this;
        }

        public Builder titleLevel13(String titleLevel13) {
            this.titleLevel13 = titleLevel13;
            this.changedFields = changedFields.add("TitleLevel13");
            return this;
        }

        public Builder idLevel14(Integer idLevel14) {
            this.idLevel14 = idLevel14;
            this.changedFields = changedFields.add("IdLevel14");
            return this;
        }

        public Builder titleLevel14(String titleLevel14) {
            this.titleLevel14 = titleLevel14;
            this.changedFields = changedFields.add("TitleLevel14");
            return this;
        }

        public Builder depth(UnsignedByte depth) {
            this.depth = depth;
            this.changedFields = changedFields.add("Depth");
            return this;
        }

        public Builder type(TestSuiteType type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder requirementWorkItemId(Integer requirementWorkItemId) {
            this.requirementWorkItemId = requirementWorkItemId;
            this.changedFields = changedFields.add("RequirementWorkItemId");
            return this;
        }

        public TestSuite build() {
            TestSuite _x = new TestSuite();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite";
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.projectSK = projectSK;
            _x.testSuiteSK = testSuiteSK;
            _x.testPlanId = testPlanId;
            _x.testSuiteId = testSuiteId;
            _x.testPlanTitle = testPlanTitle;
            _x.title = title;
            _x.orderId = orderId;
            _x.idLevel1 = idLevel1;
            _x.titleLevel1 = titleLevel1;
            _x.idLevel2 = idLevel2;
            _x.titleLevel2 = titleLevel2;
            _x.idLevel3 = idLevel3;
            _x.titleLevel3 = titleLevel3;
            _x.idLevel4 = idLevel4;
            _x.titleLevel4 = titleLevel4;
            _x.idLevel5 = idLevel5;
            _x.titleLevel5 = titleLevel5;
            _x.idLevel6 = idLevel6;
            _x.titleLevel6 = titleLevel6;
            _x.idLevel7 = idLevel7;
            _x.titleLevel7 = titleLevel7;
            _x.idLevel8 = idLevel8;
            _x.titleLevel8 = titleLevel8;
            _x.idLevel9 = idLevel9;
            _x.titleLevel9 = titleLevel9;
            _x.idLevel10 = idLevel10;
            _x.titleLevel10 = titleLevel10;
            _x.idLevel11 = idLevel11;
            _x.titleLevel11 = titleLevel11;
            _x.idLevel12 = idLevel12;
            _x.titleLevel12 = titleLevel12;
            _x.idLevel13 = idLevel13;
            _x.titleLevel13 = titleLevel13;
            _x.idLevel14 = idLevel14;
            _x.titleLevel14 = titleLevel14;
            _x.depth = depth;
            _x.type = type;
            _x.requirementWorkItemId = requirementWorkItemId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && testSuiteSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(testSuiteSK.toString()));
        }
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public TestSuite withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public TestSuite withProjectSK(String projectSK) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestSuiteSK")
    @JsonIgnore
    public Optional<Integer> getTestSuiteSK() {
        return Optional.ofNullable(testSuiteSK);
    }

    public TestSuite withTestSuiteSK(Integer testSuiteSK) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TestSuiteSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.testSuiteSK = testSuiteSK;
        return _x;
    }

    @Property(name="TestPlanId")
    @JsonIgnore
    public Optional<Integer> getTestPlanId() {
        return Optional.ofNullable(testPlanId);
    }

    public TestSuite withTestPlanId(Integer testPlanId) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TestPlanId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.testPlanId = testPlanId;
        return _x;
    }

    @Property(name="TestSuiteId")
    @JsonIgnore
    public Optional<Integer> getTestSuiteId() {
        return Optional.ofNullable(testSuiteId);
    }

    public TestSuite withTestSuiteId(Integer testSuiteId) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TestSuiteId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.testSuiteId = testSuiteId;
        return _x;
    }

    @Property(name="TestPlanTitle")
    @JsonIgnore
    public Optional<String> getTestPlanTitle() {
        return Optional.ofNullable(testPlanTitle);
    }

    public TestSuite withTestPlanTitle(String testPlanTitle) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TestPlanTitle");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.testPlanTitle = testPlanTitle;
        return _x;
    }

    @Property(name="Title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public TestSuite withTitle(String title) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("Title");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.title = title;
        return _x;
    }

    @Property(name="OrderId")
    @JsonIgnore
    public Optional<Integer> getOrderId() {
        return Optional.ofNullable(orderId);
    }

    public TestSuite withOrderId(Integer orderId) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("OrderId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.orderId = orderId;
        return _x;
    }

    @Property(name="IdLevel1")
    @JsonIgnore
    public Optional<Integer> getIdLevel1() {
        return Optional.ofNullable(idLevel1);
    }

    public TestSuite withIdLevel1(Integer idLevel1) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel1");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel1 = idLevel1;
        return _x;
    }

    @Property(name="TitleLevel1")
    @JsonIgnore
    public Optional<String> getTitleLevel1() {
        return Optional.ofNullable(titleLevel1);
    }

    public TestSuite withTitleLevel1(String titleLevel1) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel1");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel1 = titleLevel1;
        return _x;
    }

    @Property(name="IdLevel2")
    @JsonIgnore
    public Optional<Integer> getIdLevel2() {
        return Optional.ofNullable(idLevel2);
    }

    public TestSuite withIdLevel2(Integer idLevel2) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel2");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel2 = idLevel2;
        return _x;
    }

    @Property(name="TitleLevel2")
    @JsonIgnore
    public Optional<String> getTitleLevel2() {
        return Optional.ofNullable(titleLevel2);
    }

    public TestSuite withTitleLevel2(String titleLevel2) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel2");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel2 = titleLevel2;
        return _x;
    }

    @Property(name="IdLevel3")
    @JsonIgnore
    public Optional<Integer> getIdLevel3() {
        return Optional.ofNullable(idLevel3);
    }

    public TestSuite withIdLevel3(Integer idLevel3) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel3");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel3 = idLevel3;
        return _x;
    }

    @Property(name="TitleLevel3")
    @JsonIgnore
    public Optional<String> getTitleLevel3() {
        return Optional.ofNullable(titleLevel3);
    }

    public TestSuite withTitleLevel3(String titleLevel3) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel3");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel3 = titleLevel3;
        return _x;
    }

    @Property(name="IdLevel4")
    @JsonIgnore
    public Optional<Integer> getIdLevel4() {
        return Optional.ofNullable(idLevel4);
    }

    public TestSuite withIdLevel4(Integer idLevel4) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel4");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel4 = idLevel4;
        return _x;
    }

    @Property(name="TitleLevel4")
    @JsonIgnore
    public Optional<String> getTitleLevel4() {
        return Optional.ofNullable(titleLevel4);
    }

    public TestSuite withTitleLevel4(String titleLevel4) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel4");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel4 = titleLevel4;
        return _x;
    }

    @Property(name="IdLevel5")
    @JsonIgnore
    public Optional<Integer> getIdLevel5() {
        return Optional.ofNullable(idLevel5);
    }

    public TestSuite withIdLevel5(Integer idLevel5) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel5");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel5 = idLevel5;
        return _x;
    }

    @Property(name="TitleLevel5")
    @JsonIgnore
    public Optional<String> getTitleLevel5() {
        return Optional.ofNullable(titleLevel5);
    }

    public TestSuite withTitleLevel5(String titleLevel5) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel5");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel5 = titleLevel5;
        return _x;
    }

    @Property(name="IdLevel6")
    @JsonIgnore
    public Optional<Integer> getIdLevel6() {
        return Optional.ofNullable(idLevel6);
    }

    public TestSuite withIdLevel6(Integer idLevel6) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel6");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel6 = idLevel6;
        return _x;
    }

    @Property(name="TitleLevel6")
    @JsonIgnore
    public Optional<String> getTitleLevel6() {
        return Optional.ofNullable(titleLevel6);
    }

    public TestSuite withTitleLevel6(String titleLevel6) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel6");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel6 = titleLevel6;
        return _x;
    }

    @Property(name="IdLevel7")
    @JsonIgnore
    public Optional<Integer> getIdLevel7() {
        return Optional.ofNullable(idLevel7);
    }

    public TestSuite withIdLevel7(Integer idLevel7) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel7");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel7 = idLevel7;
        return _x;
    }

    @Property(name="TitleLevel7")
    @JsonIgnore
    public Optional<String> getTitleLevel7() {
        return Optional.ofNullable(titleLevel7);
    }

    public TestSuite withTitleLevel7(String titleLevel7) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel7");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel7 = titleLevel7;
        return _x;
    }

    @Property(name="IdLevel8")
    @JsonIgnore
    public Optional<Integer> getIdLevel8() {
        return Optional.ofNullable(idLevel8);
    }

    public TestSuite withIdLevel8(Integer idLevel8) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel8");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel8 = idLevel8;
        return _x;
    }

    @Property(name="TitleLevel8")
    @JsonIgnore
    public Optional<String> getTitleLevel8() {
        return Optional.ofNullable(titleLevel8);
    }

    public TestSuite withTitleLevel8(String titleLevel8) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel8");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel8 = titleLevel8;
        return _x;
    }

    @Property(name="IdLevel9")
    @JsonIgnore
    public Optional<Integer> getIdLevel9() {
        return Optional.ofNullable(idLevel9);
    }

    public TestSuite withIdLevel9(Integer idLevel9) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel9");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel9 = idLevel9;
        return _x;
    }

    @Property(name="TitleLevel9")
    @JsonIgnore
    public Optional<String> getTitleLevel9() {
        return Optional.ofNullable(titleLevel9);
    }

    public TestSuite withTitleLevel9(String titleLevel9) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel9");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel9 = titleLevel9;
        return _x;
    }

    @Property(name="IdLevel10")
    @JsonIgnore
    public Optional<Integer> getIdLevel10() {
        return Optional.ofNullable(idLevel10);
    }

    public TestSuite withIdLevel10(Integer idLevel10) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel10");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel10 = idLevel10;
        return _x;
    }

    @Property(name="TitleLevel10")
    @JsonIgnore
    public Optional<String> getTitleLevel10() {
        return Optional.ofNullable(titleLevel10);
    }

    public TestSuite withTitleLevel10(String titleLevel10) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel10");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel10 = titleLevel10;
        return _x;
    }

    @Property(name="IdLevel11")
    @JsonIgnore
    public Optional<Integer> getIdLevel11() {
        return Optional.ofNullable(idLevel11);
    }

    public TestSuite withIdLevel11(Integer idLevel11) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel11");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel11 = idLevel11;
        return _x;
    }

    @Property(name="TitleLevel11")
    @JsonIgnore
    public Optional<String> getTitleLevel11() {
        return Optional.ofNullable(titleLevel11);
    }

    public TestSuite withTitleLevel11(String titleLevel11) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel11");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel11 = titleLevel11;
        return _x;
    }

    @Property(name="IdLevel12")
    @JsonIgnore
    public Optional<Integer> getIdLevel12() {
        return Optional.ofNullable(idLevel12);
    }

    public TestSuite withIdLevel12(Integer idLevel12) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel12");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel12 = idLevel12;
        return _x;
    }

    @Property(name="TitleLevel12")
    @JsonIgnore
    public Optional<String> getTitleLevel12() {
        return Optional.ofNullable(titleLevel12);
    }

    public TestSuite withTitleLevel12(String titleLevel12) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel12");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel12 = titleLevel12;
        return _x;
    }

    @Property(name="IdLevel13")
    @JsonIgnore
    public Optional<Integer> getIdLevel13() {
        return Optional.ofNullable(idLevel13);
    }

    public TestSuite withIdLevel13(Integer idLevel13) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel13");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel13 = idLevel13;
        return _x;
    }

    @Property(name="TitleLevel13")
    @JsonIgnore
    public Optional<String> getTitleLevel13() {
        return Optional.ofNullable(titleLevel13);
    }

    public TestSuite withTitleLevel13(String titleLevel13) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel13");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel13 = titleLevel13;
        return _x;
    }

    @Property(name="IdLevel14")
    @JsonIgnore
    public Optional<Integer> getIdLevel14() {
        return Optional.ofNullable(idLevel14);
    }

    public TestSuite withIdLevel14(Integer idLevel14) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("IdLevel14");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.idLevel14 = idLevel14;
        return _x;
    }

    @Property(name="TitleLevel14")
    @JsonIgnore
    public Optional<String> getTitleLevel14() {
        return Optional.ofNullable(titleLevel14);
    }

    public TestSuite withTitleLevel14(String titleLevel14) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("TitleLevel14");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.titleLevel14 = titleLevel14;
        return _x;
    }

    @Property(name="Depth")
    @JsonIgnore
    public Optional<UnsignedByte> getDepth() {
        return Optional.ofNullable(depth);
    }

    public TestSuite withDepth(UnsignedByte depth) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("Depth");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.depth = depth;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<TestSuiteType> getType() {
        return Optional.ofNullable(type);
    }

    public TestSuite withType(TestSuiteType type) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("Type");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.type = type;
        return _x;
    }

    @Property(name="RequirementWorkItemId")
    @JsonIgnore
    public Optional<Integer> getRequirementWorkItemId() {
        return Optional.ofNullable(requirementWorkItemId);
    }

    public TestSuite withRequirementWorkItemId(Integer requirementWorkItemId) {
        TestSuite _x = _copy();
        _x.changedFields = changedFields.add("RequirementWorkItemId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestSuite");
        _x.requirementWorkItemId = requirementWorkItemId;
        return _x;
    }

    public TestSuite withUnmappedField(String name, String value) {
        TestSuite _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="TestSuiteWorkItem")
    @JsonIgnore
    public WorkItemRequest getTestSuiteWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TestSuiteWorkItem"), RequestHelper.getValue(unmappedFields, "TestSuiteWorkItem"));
    }

    @NavigationProperty(name="TestPlanWorkItem")
    @JsonIgnore
    public WorkItemRequest getTestPlanWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TestPlanWorkItem"), RequestHelper.getValue(unmappedFields, "TestPlanWorkItem"));
    }

    @NavigationProperty(name="RequirementWorkItem")
    @JsonIgnore
    public WorkItemRequest getRequirementWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("RequirementWorkItem"), RequestHelper.getValue(unmappedFields, "RequirementWorkItem"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestSuite patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TestSuite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestSuite put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TestSuite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TestSuite _copy() {
        TestSuite _x = new TestSuite();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.projectSK = projectSK;
        _x.testSuiteSK = testSuiteSK;
        _x.testPlanId = testPlanId;
        _x.testSuiteId = testSuiteId;
        _x.testPlanTitle = testPlanTitle;
        _x.title = title;
        _x.orderId = orderId;
        _x.idLevel1 = idLevel1;
        _x.titleLevel1 = titleLevel1;
        _x.idLevel2 = idLevel2;
        _x.titleLevel2 = titleLevel2;
        _x.idLevel3 = idLevel3;
        _x.titleLevel3 = titleLevel3;
        _x.idLevel4 = idLevel4;
        _x.titleLevel4 = titleLevel4;
        _x.idLevel5 = idLevel5;
        _x.titleLevel5 = titleLevel5;
        _x.idLevel6 = idLevel6;
        _x.titleLevel6 = titleLevel6;
        _x.idLevel7 = idLevel7;
        _x.titleLevel7 = titleLevel7;
        _x.idLevel8 = idLevel8;
        _x.titleLevel8 = titleLevel8;
        _x.idLevel9 = idLevel9;
        _x.titleLevel9 = titleLevel9;
        _x.idLevel10 = idLevel10;
        _x.titleLevel10 = titleLevel10;
        _x.idLevel11 = idLevel11;
        _x.titleLevel11 = titleLevel11;
        _x.idLevel12 = idLevel12;
        _x.titleLevel12 = titleLevel12;
        _x.idLevel13 = idLevel13;
        _x.titleLevel13 = titleLevel13;
        _x.idLevel14 = idLevel14;
        _x.titleLevel14 = titleLevel14;
        _x.depth = depth;
        _x.type = type;
        _x.requirementWorkItemId = requirementWorkItemId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TestSuite[");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestSuiteSK=");
        b.append(this.testSuiteSK);
        b.append(", ");
        b.append("TestPlanId=");
        b.append(this.testPlanId);
        b.append(", ");
        b.append("TestSuiteId=");
        b.append(this.testSuiteId);
        b.append(", ");
        b.append("TestPlanTitle=");
        b.append(this.testPlanTitle);
        b.append(", ");
        b.append("Title=");
        b.append(this.title);
        b.append(", ");
        b.append("OrderId=");
        b.append(this.orderId);
        b.append(", ");
        b.append("IdLevel1=");
        b.append(this.idLevel1);
        b.append(", ");
        b.append("TitleLevel1=");
        b.append(this.titleLevel1);
        b.append(", ");
        b.append("IdLevel2=");
        b.append(this.idLevel2);
        b.append(", ");
        b.append("TitleLevel2=");
        b.append(this.titleLevel2);
        b.append(", ");
        b.append("IdLevel3=");
        b.append(this.idLevel3);
        b.append(", ");
        b.append("TitleLevel3=");
        b.append(this.titleLevel3);
        b.append(", ");
        b.append("IdLevel4=");
        b.append(this.idLevel4);
        b.append(", ");
        b.append("TitleLevel4=");
        b.append(this.titleLevel4);
        b.append(", ");
        b.append("IdLevel5=");
        b.append(this.idLevel5);
        b.append(", ");
        b.append("TitleLevel5=");
        b.append(this.titleLevel5);
        b.append(", ");
        b.append("IdLevel6=");
        b.append(this.idLevel6);
        b.append(", ");
        b.append("TitleLevel6=");
        b.append(this.titleLevel6);
        b.append(", ");
        b.append("IdLevel7=");
        b.append(this.idLevel7);
        b.append(", ");
        b.append("TitleLevel7=");
        b.append(this.titleLevel7);
        b.append(", ");
        b.append("IdLevel8=");
        b.append(this.idLevel8);
        b.append(", ");
        b.append("TitleLevel8=");
        b.append(this.titleLevel8);
        b.append(", ");
        b.append("IdLevel9=");
        b.append(this.idLevel9);
        b.append(", ");
        b.append("TitleLevel9=");
        b.append(this.titleLevel9);
        b.append(", ");
        b.append("IdLevel10=");
        b.append(this.idLevel10);
        b.append(", ");
        b.append("TitleLevel10=");
        b.append(this.titleLevel10);
        b.append(", ");
        b.append("IdLevel11=");
        b.append(this.idLevel11);
        b.append(", ");
        b.append("TitleLevel11=");
        b.append(this.titleLevel11);
        b.append(", ");
        b.append("IdLevel12=");
        b.append(this.idLevel12);
        b.append(", ");
        b.append("TitleLevel12=");
        b.append(this.titleLevel12);
        b.append(", ");
        b.append("IdLevel13=");
        b.append(this.idLevel13);
        b.append(", ");
        b.append("TitleLevel13=");
        b.append(this.titleLevel13);
        b.append(", ");
        b.append("IdLevel14=");
        b.append(this.idLevel14);
        b.append(", ");
        b.append("TitleLevel14=");
        b.append(this.titleLevel14);
        b.append(", ");
        b.append("Depth=");
        b.append(this.depth);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("RequirementWorkItemId=");
        b.append(this.requirementWorkItemId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
