package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.request.BranchRequest;
import microsoft.vs.analytics.v4.model.entity.request.CalendarDateRequest;
import microsoft.vs.analytics.v4.model.entity.request.PipelineRequest;
import microsoft.vs.analytics.v4.model.entity.request.PipelineRunRequest;
import microsoft.vs.analytics.v4.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v4.model.entity.request.TestRequest;
import microsoft.vs.analytics.v4.model.entity.request.TestRunRequest;
import microsoft.vs.analytics.v4.model.enums.SourceWorkflow;
import microsoft.vs.analytics.v4.model.enums.TestOutcome;
import microsoft.vs.analytics.v4.model.enums.TestRunType;

@JsonPropertyOrder({
    "@odata.type", 
    "AnalyticsUpdatedDate", 
    "ProjectSK", 
    "TestResultSK", 
    "TestResultId", 
    "TestRunSK", 
    "TestRunId", 
    "Outcome", 
    "TestSK", 
    "PipelineRunSK", 
    "PipelineSK", 
    "BranchSK", 
    "CompletedDateSK", 
    "CompletedDate", 
    "StartedDateSK", 
    "StartedDate", 
    "DurationSeconds", 
    "TestRunType", 
    "Workflow", 
    "ReleaseId", 
    "ReleaseEnvironmentId", 
    "ReleasePipelineId", 
    "ReleaseStageId", 
    "IsFlaky"})
@JsonInclude(Include.NON_NULL)
public class TestResult implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.TestResult";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestResultSK")
    protected Long testResultSK;

    @JsonProperty("TestResultId")
    protected Integer testResultId;

    @JsonProperty("TestRunSK")
    protected Integer testRunSK;

    @JsonProperty("TestRunId")
    protected Integer testRunId;

    @JsonProperty("Outcome")
    protected TestOutcome outcome;

    @JsonProperty("TestSK")
    protected Integer testSK;

    @JsonProperty("PipelineRunSK")
    protected Integer pipelineRunSK;

    @JsonProperty("PipelineSK")
    protected Integer pipelineSK;

    @JsonProperty("BranchSK")
    protected Integer branchSK;

    @JsonProperty("CompletedDateSK")
    protected Integer completedDateSK;

    @JsonProperty("CompletedDate")
    protected OffsetDateTime completedDate;

    @JsonProperty("StartedDateSK")
    protected Integer startedDateSK;

    @JsonProperty("StartedDate")
    protected OffsetDateTime startedDate;

    @JsonProperty("DurationSeconds")
    protected BigDecimal durationSeconds;

    @JsonProperty("TestRunType")
    protected TestRunType testRunType;

    @JsonProperty("Workflow")
    protected SourceWorkflow workflow;

    @JsonProperty("ReleaseId")
    protected Integer releaseId;

    @JsonProperty("ReleaseEnvironmentId")
    protected Integer releaseEnvironmentId;

    @JsonProperty("ReleasePipelineId")
    protected Integer releasePipelineId;

    @JsonProperty("ReleaseStageId")
    protected Integer releaseStageId;

    @JsonProperty("IsFlaky")
    protected Boolean isFlaky;

    protected TestResult() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime analyticsUpdatedDate;
        private String projectSK;
        private Long testResultSK;
        private Integer testResultId;
        private Integer testRunSK;
        private Integer testRunId;
        private TestOutcome outcome;
        private Integer testSK;
        private Integer pipelineRunSK;
        private Integer pipelineSK;
        private Integer branchSK;
        private Integer completedDateSK;
        private OffsetDateTime completedDate;
        private Integer startedDateSK;
        private OffsetDateTime startedDate;
        private BigDecimal durationSeconds;
        private TestRunType testRunType;
        private SourceWorkflow workflow;
        private Integer releaseId;
        private Integer releaseEnvironmentId;
        private Integer releasePipelineId;
        private Integer releaseStageId;
        private Boolean isFlaky;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testResultSK(Long testResultSK) {
            this.testResultSK = testResultSK;
            this.changedFields = changedFields.add("TestResultSK");
            return this;
        }

        public Builder testResultId(Integer testResultId) {
            this.testResultId = testResultId;
            this.changedFields = changedFields.add("TestResultId");
            return this;
        }

        public Builder testRunSK(Integer testRunSK) {
            this.testRunSK = testRunSK;
            this.changedFields = changedFields.add("TestRunSK");
            return this;
        }

        public Builder testRunId(Integer testRunId) {
            this.testRunId = testRunId;
            this.changedFields = changedFields.add("TestRunId");
            return this;
        }

        public Builder outcome(TestOutcome outcome) {
            this.outcome = outcome;
            this.changedFields = changedFields.add("Outcome");
            return this;
        }

        public Builder testSK(Integer testSK) {
            this.testSK = testSK;
            this.changedFields = changedFields.add("TestSK");
            return this;
        }

        public Builder pipelineRunSK(Integer pipelineRunSK) {
            this.pipelineRunSK = pipelineRunSK;
            this.changedFields = changedFields.add("PipelineRunSK");
            return this;
        }

        public Builder pipelineSK(Integer pipelineSK) {
            this.pipelineSK = pipelineSK;
            this.changedFields = changedFields.add("PipelineSK");
            return this;
        }

        public Builder branchSK(Integer branchSK) {
            this.branchSK = branchSK;
            this.changedFields = changedFields.add("BranchSK");
            return this;
        }

        public Builder completedDateSK(Integer completedDateSK) {
            this.completedDateSK = completedDateSK;
            this.changedFields = changedFields.add("CompletedDateSK");
            return this;
        }

        public Builder completedDate(OffsetDateTime completedDate) {
            this.completedDate = completedDate;
            this.changedFields = changedFields.add("CompletedDate");
            return this;
        }

        public Builder startedDateSK(Integer startedDateSK) {
            this.startedDateSK = startedDateSK;
            this.changedFields = changedFields.add("StartedDateSK");
            return this;
        }

        public Builder startedDate(OffsetDateTime startedDate) {
            this.startedDate = startedDate;
            this.changedFields = changedFields.add("StartedDate");
            return this;
        }

        public Builder durationSeconds(BigDecimal durationSeconds) {
            this.durationSeconds = durationSeconds;
            this.changedFields = changedFields.add("DurationSeconds");
            return this;
        }

        public Builder testRunType(TestRunType testRunType) {
            this.testRunType = testRunType;
            this.changedFields = changedFields.add("TestRunType");
            return this;
        }

        public Builder workflow(SourceWorkflow workflow) {
            this.workflow = workflow;
            this.changedFields = changedFields.add("Workflow");
            return this;
        }

        public Builder releaseId(Integer releaseId) {
            this.releaseId = releaseId;
            this.changedFields = changedFields.add("ReleaseId");
            return this;
        }

        public Builder releaseEnvironmentId(Integer releaseEnvironmentId) {
            this.releaseEnvironmentId = releaseEnvironmentId;
            this.changedFields = changedFields.add("ReleaseEnvironmentId");
            return this;
        }

        public Builder releasePipelineId(Integer releasePipelineId) {
            this.releasePipelineId = releasePipelineId;
            this.changedFields = changedFields.add("ReleasePipelineId");
            return this;
        }

        public Builder releaseStageId(Integer releaseStageId) {
            this.releaseStageId = releaseStageId;
            this.changedFields = changedFields.add("ReleaseStageId");
            return this;
        }

        public Builder isFlaky(Boolean isFlaky) {
            this.isFlaky = isFlaky;
            this.changedFields = changedFields.add("IsFlaky");
            return this;
        }

        public TestResult build() {
            TestResult _x = new TestResult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.TestResult";
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.projectSK = projectSK;
            _x.testResultSK = testResultSK;
            _x.testResultId = testResultId;
            _x.testRunSK = testRunSK;
            _x.testRunId = testRunId;
            _x.outcome = outcome;
            _x.testSK = testSK;
            _x.pipelineRunSK = pipelineRunSK;
            _x.pipelineSK = pipelineSK;
            _x.branchSK = branchSK;
            _x.completedDateSK = completedDateSK;
            _x.completedDate = completedDate;
            _x.startedDateSK = startedDateSK;
            _x.startedDate = startedDate;
            _x.durationSeconds = durationSeconds;
            _x.testRunType = testRunType;
            _x.workflow = workflow;
            _x.releaseId = releaseId;
            _x.releaseEnvironmentId = releaseEnvironmentId;
            _x.releasePipelineId = releasePipelineId;
            _x.releaseStageId = releaseStageId;
            _x.isFlaky = isFlaky;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && testResultSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(testResultSK.toString()));
        }
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public TestResult withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public TestResult withProjectSK(String projectSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestResultSK")
    @JsonIgnore
    public Optional<Long> getTestResultSK() {
        return Optional.ofNullable(testResultSK);
    }

    public TestResult withTestResultSK(Long testResultSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestResultSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testResultSK = testResultSK;
        return _x;
    }

    @Property(name="TestResultId")
    @JsonIgnore
    public Optional<Integer> getTestResultId() {
        return Optional.ofNullable(testResultId);
    }

    public TestResult withTestResultId(Integer testResultId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestResultId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testResultId = testResultId;
        return _x;
    }

    @Property(name="TestRunSK")
    @JsonIgnore
    public Optional<Integer> getTestRunSK() {
        return Optional.ofNullable(testRunSK);
    }

    public TestResult withTestRunSK(Integer testRunSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestRunSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testRunSK = testRunSK;
        return _x;
    }

    @Property(name="TestRunId")
    @JsonIgnore
    public Optional<Integer> getTestRunId() {
        return Optional.ofNullable(testRunId);
    }

    public TestResult withTestRunId(Integer testRunId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestRunId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testRunId = testRunId;
        return _x;
    }

    @Property(name="Outcome")
    @JsonIgnore
    public Optional<TestOutcome> getOutcome() {
        return Optional.ofNullable(outcome);
    }

    public TestResult withOutcome(TestOutcome outcome) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("Outcome");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.outcome = outcome;
        return _x;
    }

    @Property(name="TestSK")
    @JsonIgnore
    public Optional<Integer> getTestSK() {
        return Optional.ofNullable(testSK);
    }

    public TestResult withTestSK(Integer testSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testSK = testSK;
        return _x;
    }

    @Property(name="PipelineRunSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunSK() {
        return Optional.ofNullable(pipelineRunSK);
    }

    public TestResult withPipelineRunSK(Integer pipelineRunSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.pipelineRunSK = pipelineRunSK;
        return _x;
    }

    @Property(name="PipelineSK")
    @JsonIgnore
    public Optional<Integer> getPipelineSK() {
        return Optional.ofNullable(pipelineSK);
    }

    public TestResult withPipelineSK(Integer pipelineSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.pipelineSK = pipelineSK;
        return _x;
    }

    @Property(name="BranchSK")
    @JsonIgnore
    public Optional<Integer> getBranchSK() {
        return Optional.ofNullable(branchSK);
    }

    public TestResult withBranchSK(Integer branchSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("BranchSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.branchSK = branchSK;
        return _x;
    }

    @Property(name="CompletedDateSK")
    @JsonIgnore
    public Optional<Integer> getCompletedDateSK() {
        return Optional.ofNullable(completedDateSK);
    }

    public TestResult withCompletedDateSK(Integer completedDateSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("CompletedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.completedDateSK = completedDateSK;
        return _x;
    }

    @Property(name="CompletedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    public TestResult withCompletedDate(OffsetDateTime completedDate) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("CompletedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.completedDate = completedDate;
        return _x;
    }

    @Property(name="StartedDateSK")
    @JsonIgnore
    public Optional<Integer> getStartedDateSK() {
        return Optional.ofNullable(startedDateSK);
    }

    public TestResult withStartedDateSK(Integer startedDateSK) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("StartedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.startedDateSK = startedDateSK;
        return _x;
    }

    @Property(name="StartedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedDate() {
        return Optional.ofNullable(startedDate);
    }

    public TestResult withStartedDate(OffsetDateTime startedDate) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("StartedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.startedDate = startedDate;
        return _x;
    }

    @Property(name="DurationSeconds")
    @JsonIgnore
    public Optional<BigDecimal> getDurationSeconds() {
        return Optional.ofNullable(durationSeconds);
    }

    public TestResult withDurationSeconds(BigDecimal durationSeconds) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("DurationSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.durationSeconds = durationSeconds;
        return _x;
    }

    @Property(name="TestRunType")
    @JsonIgnore
    public Optional<TestRunType> getTestRunType() {
        return Optional.ofNullable(testRunType);
    }

    public TestResult withTestRunType(TestRunType testRunType) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("TestRunType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.testRunType = testRunType;
        return _x;
    }

    @Property(name="Workflow")
    @JsonIgnore
    public Optional<SourceWorkflow> getWorkflow() {
        return Optional.ofNullable(workflow);
    }

    public TestResult withWorkflow(SourceWorkflow workflow) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("Workflow");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.workflow = workflow;
        return _x;
    }

    @Property(name="ReleaseId")
    @JsonIgnore
    public Optional<Integer> getReleaseId() {
        return Optional.ofNullable(releaseId);
    }

    public TestResult withReleaseId(Integer releaseId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("ReleaseId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.releaseId = releaseId;
        return _x;
    }

    @Property(name="ReleaseEnvironmentId")
    @JsonIgnore
    public Optional<Integer> getReleaseEnvironmentId() {
        return Optional.ofNullable(releaseEnvironmentId);
    }

    public TestResult withReleaseEnvironmentId(Integer releaseEnvironmentId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("ReleaseEnvironmentId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.releaseEnvironmentId = releaseEnvironmentId;
        return _x;
    }

    @Property(name="ReleasePipelineId")
    @JsonIgnore
    public Optional<Integer> getReleasePipelineId() {
        return Optional.ofNullable(releasePipelineId);
    }

    public TestResult withReleasePipelineId(Integer releasePipelineId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("ReleasePipelineId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.releasePipelineId = releasePipelineId;
        return _x;
    }

    @Property(name="ReleaseStageId")
    @JsonIgnore
    public Optional<Integer> getReleaseStageId() {
        return Optional.ofNullable(releaseStageId);
    }

    public TestResult withReleaseStageId(Integer releaseStageId) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("ReleaseStageId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.releaseStageId = releaseStageId;
        return _x;
    }

    @Property(name="IsFlaky")
    @JsonIgnore
    public Optional<Boolean> getIsFlaky() {
        return Optional.ofNullable(isFlaky);
    }

    public TestResult withIsFlaky(Boolean isFlaky) {
        TestResult _x = _copy();
        _x.changedFields = changedFields.add("IsFlaky");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestResult");
        _x.isFlaky = isFlaky;
        return _x;
    }

    public TestResult withUnmappedField(String name, String value) {
        TestResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="TestRun")
    @JsonIgnore
    public TestRunRequest getTestRun() {
        return new TestRunRequest(contextPath.addSegment("TestRun"), RequestHelper.getValue(unmappedFields, "TestRun"));
    }

    @NavigationProperty(name="Test")
    @JsonIgnore
    public TestRequest getTest() {
        return new TestRequest(contextPath.addSegment("Test"), RequestHelper.getValue(unmappedFields, "Test"));
    }

    @NavigationProperty(name="PipelineRun")
    @JsonIgnore
    public PipelineRunRequest getPipelineRun() {
        return new PipelineRunRequest(contextPath.addSegment("PipelineRun"), RequestHelper.getValue(unmappedFields, "PipelineRun"));
    }

    @NavigationProperty(name="Pipeline")
    @JsonIgnore
    public PipelineRequest getPipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), RequestHelper.getValue(unmappedFields, "Pipeline"));
    }

    @NavigationProperty(name="Branch")
    @JsonIgnore
    public BranchRequest getBranch() {
        return new BranchRequest(contextPath.addSegment("Branch"), RequestHelper.getValue(unmappedFields, "Branch"));
    }

    @NavigationProperty(name="CompletedOn")
    @JsonIgnore
    public CalendarDateRequest getCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("CompletedOn"), RequestHelper.getValue(unmappedFields, "CompletedOn"));
    }

    @NavigationProperty(name="StartedOn")
    @JsonIgnore
    public CalendarDateRequest getStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("StartedOn"), RequestHelper.getValue(unmappedFields, "StartedOn"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestResult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TestResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestResult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TestResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TestResult _copy() {
        TestResult _x = new TestResult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.projectSK = projectSK;
        _x.testResultSK = testResultSK;
        _x.testResultId = testResultId;
        _x.testRunSK = testRunSK;
        _x.testRunId = testRunId;
        _x.outcome = outcome;
        _x.testSK = testSK;
        _x.pipelineRunSK = pipelineRunSK;
        _x.pipelineSK = pipelineSK;
        _x.branchSK = branchSK;
        _x.completedDateSK = completedDateSK;
        _x.completedDate = completedDate;
        _x.startedDateSK = startedDateSK;
        _x.startedDate = startedDate;
        _x.durationSeconds = durationSeconds;
        _x.testRunType = testRunType;
        _x.workflow = workflow;
        _x.releaseId = releaseId;
        _x.releaseEnvironmentId = releaseEnvironmentId;
        _x.releasePipelineId = releasePipelineId;
        _x.releaseStageId = releaseStageId;
        _x.isFlaky = isFlaky;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TestResult[");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestResultSK=");
        b.append(this.testResultSK);
        b.append(", ");
        b.append("TestResultId=");
        b.append(this.testResultId);
        b.append(", ");
        b.append("TestRunSK=");
        b.append(this.testRunSK);
        b.append(", ");
        b.append("TestRunId=");
        b.append(this.testRunId);
        b.append(", ");
        b.append("Outcome=");
        b.append(this.outcome);
        b.append(", ");
        b.append("TestSK=");
        b.append(this.testSK);
        b.append(", ");
        b.append("PipelineRunSK=");
        b.append(this.pipelineRunSK);
        b.append(", ");
        b.append("PipelineSK=");
        b.append(this.pipelineSK);
        b.append(", ");
        b.append("BranchSK=");
        b.append(this.branchSK);
        b.append(", ");
        b.append("CompletedDateSK=");
        b.append(this.completedDateSK);
        b.append(", ");
        b.append("CompletedDate=");
        b.append(this.completedDate);
        b.append(", ");
        b.append("StartedDateSK=");
        b.append(this.startedDateSK);
        b.append(", ");
        b.append("StartedDate=");
        b.append(this.startedDate);
        b.append(", ");
        b.append("DurationSeconds=");
        b.append(this.durationSeconds);
        b.append(", ");
        b.append("TestRunType=");
        b.append(this.testRunType);
        b.append(", ");
        b.append("Workflow=");
        b.append(this.workflow);
        b.append(", ");
        b.append("ReleaseId=");
        b.append(this.releaseId);
        b.append(", ");
        b.append("ReleaseEnvironmentId=");
        b.append(this.releaseEnvironmentId);
        b.append(", ");
        b.append("ReleasePipelineId=");
        b.append(this.releasePipelineId);
        b.append(", ");
        b.append("ReleaseStageId=");
        b.append(this.releaseStageId);
        b.append(", ");
        b.append("IsFlaky=");
        b.append(this.isFlaky);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
