package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "TestConfigurationSK", 
    "TestConfigurationId", 
    "Name", 
    "State"})
@JsonInclude(Include.NON_NULL)
public class TestConfiguration implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestConfigurationSK")
    protected Integer testConfigurationSK;

    @JsonProperty("TestConfigurationId")
    protected Integer testConfigurationId;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("State")
    protected String state;

    protected TestConfiguration() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer testConfigurationSK;
        private Integer testConfigurationId;
        private String name;
        private String state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testConfigurationSK(Integer testConfigurationSK) {
            this.testConfigurationSK = testConfigurationSK;
            this.changedFields = changedFields.add("TestConfigurationSK");
            return this;
        }

        public Builder testConfigurationId(Integer testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            this.changedFields = changedFields.add("TestConfigurationId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("State");
            return this;
        }

        public TestConfiguration build() {
            TestConfiguration _x = new TestConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration";
            _x.projectSK = projectSK;
            _x.testConfigurationSK = testConfigurationSK;
            _x.testConfigurationId = testConfigurationId;
            _x.name = name;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && testConfigurationSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(testConfigurationSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public TestConfiguration withProjectSK(String projectSK) {
        TestConfiguration _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestConfigurationSK")
    @JsonIgnore
    public Optional<Integer> getTestConfigurationSK() {
        return Optional.ofNullable(testConfigurationSK);
    }

    public TestConfiguration withTestConfigurationSK(Integer testConfigurationSK) {
        TestConfiguration _x = _copy();
        _x.changedFields = changedFields.add("TestConfigurationSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration");
        _x.testConfigurationSK = testConfigurationSK;
        return _x;
    }

    @Property(name="TestConfigurationId")
    @JsonIgnore
    public Optional<Integer> getTestConfigurationId() {
        return Optional.ofNullable(testConfigurationId);
    }

    public TestConfiguration withTestConfigurationId(Integer testConfigurationId) {
        TestConfiguration _x = _copy();
        _x.changedFields = changedFields.add("TestConfigurationId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration");
        _x.testConfigurationId = testConfigurationId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public TestConfiguration withName(String name) {
        TestConfiguration _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration");
        _x.name = name;
        return _x;
    }

    @Property(name="State")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public TestConfiguration withState(String state) {
        TestConfiguration _x = _copy();
        _x.changedFields = changedFields.add("State");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestConfiguration");
        _x.state = state;
        return _x;
    }

    public TestConfiguration withUnmappedField(String name, String value) {
        TestConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TestConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TestConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TestConfiguration _copy() {
        TestConfiguration _x = new TestConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.testConfigurationSK = testConfigurationSK;
        _x.testConfigurationId = testConfigurationId;
        _x.name = name;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TestConfiguration[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestConfigurationSK=");
        b.append(this.testConfigurationSK);
        b.append(", ");
        b.append("TestConfigurationId=");
        b.append(this.testConfigurationId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("State=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
