package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "TestSK", 
    "TestCaseReferenceId", 
    "TestName", 
    "FullyQualifiedTestName", 
    "TestOwner", 
    "ContainerName", 
    "Priority", 
    "AnalyticsUpdatedDate"})
@JsonInclude(Include.NON_NULL)
public class Test implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Test";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestSK")
    protected Integer testSK;

    @JsonProperty("TestCaseReferenceId")
    protected Integer testCaseReferenceId;

    @JsonProperty("TestName")
    protected String testName;

    @JsonProperty("FullyQualifiedTestName")
    protected String fullyQualifiedTestName;

    @JsonProperty("TestOwner")
    protected String testOwner;

    @JsonProperty("ContainerName")
    protected String containerName;

    @JsonProperty("Priority")
    protected Integer priority;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    protected Test() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer testSK;
        private Integer testCaseReferenceId;
        private String testName;
        private String fullyQualifiedTestName;
        private String testOwner;
        private String containerName;
        private Integer priority;
        private OffsetDateTime analyticsUpdatedDate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testSK(Integer testSK) {
            this.testSK = testSK;
            this.changedFields = changedFields.add("TestSK");
            return this;
        }

        public Builder testCaseReferenceId(Integer testCaseReferenceId) {
            this.testCaseReferenceId = testCaseReferenceId;
            this.changedFields = changedFields.add("TestCaseReferenceId");
            return this;
        }

        public Builder testName(String testName) {
            this.testName = testName;
            this.changedFields = changedFields.add("TestName");
            return this;
        }

        public Builder fullyQualifiedTestName(String fullyQualifiedTestName) {
            this.fullyQualifiedTestName = fullyQualifiedTestName;
            this.changedFields = changedFields.add("FullyQualifiedTestName");
            return this;
        }

        public Builder testOwner(String testOwner) {
            this.testOwner = testOwner;
            this.changedFields = changedFields.add("TestOwner");
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            this.changedFields = changedFields.add("ContainerName");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("Priority");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Test build() {
            Test _x = new Test();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Test";
            _x.projectSK = projectSK;
            _x.testSK = testSK;
            _x.testCaseReferenceId = testCaseReferenceId;
            _x.testName = testName;
            _x.fullyQualifiedTestName = fullyQualifiedTestName;
            _x.testOwner = testOwner;
            _x.containerName = containerName;
            _x.priority = priority;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && testSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(testSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Test withProjectSK(String projectSK) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestSK")
    @JsonIgnore
    public Optional<Integer> getTestSK() {
        return Optional.ofNullable(testSK);
    }

    public Test withTestSK(Integer testSK) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("TestSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.testSK = testSK;
        return _x;
    }

    @Property(name="TestCaseReferenceId")
    @JsonIgnore
    public Optional<Integer> getTestCaseReferenceId() {
        return Optional.ofNullable(testCaseReferenceId);
    }

    public Test withTestCaseReferenceId(Integer testCaseReferenceId) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("TestCaseReferenceId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.testCaseReferenceId = testCaseReferenceId;
        return _x;
    }

    @Property(name="TestName")
    @JsonIgnore
    public Optional<String> getTestName() {
        return Optional.ofNullable(testName);
    }

    public Test withTestName(String testName) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("TestName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.testName = testName;
        return _x;
    }

    @Property(name="FullyQualifiedTestName")
    @JsonIgnore
    public Optional<String> getFullyQualifiedTestName() {
        return Optional.ofNullable(fullyQualifiedTestName);
    }

    public Test withFullyQualifiedTestName(String fullyQualifiedTestName) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("FullyQualifiedTestName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.fullyQualifiedTestName = fullyQualifiedTestName;
        return _x;
    }

    @Property(name="TestOwner")
    @JsonIgnore
    public Optional<String> getTestOwner() {
        return Optional.ofNullable(testOwner);
    }

    public Test withTestOwner(String testOwner) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("TestOwner");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.testOwner = testOwner;
        return _x;
    }

    @Property(name="ContainerName")
    @JsonIgnore
    public Optional<String> getContainerName() {
        return Optional.ofNullable(containerName);
    }

    public Test withContainerName(String containerName) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("ContainerName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.containerName = containerName;
        return _x;
    }

    @Property(name="Priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public Test withPriority(Integer priority) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("Priority");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.priority = priority;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public Test withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        Test _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Test");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    public Test withUnmappedField(String name, String value) {
        Test _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Test patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Test _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Test put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Test _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Test _copy() {
        Test _x = new Test();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.testSK = testSK;
        _x.testCaseReferenceId = testCaseReferenceId;
        _x.testName = testName;
        _x.fullyQualifiedTestName = fullyQualifiedTestName;
        _x.testOwner = testOwner;
        _x.containerName = containerName;
        _x.priority = priority;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Test[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestSK=");
        b.append(this.testSK);
        b.append(", ");
        b.append("TestCaseReferenceId=");
        b.append(this.testCaseReferenceId);
        b.append(", ");
        b.append("TestName=");
        b.append(this.testName);
        b.append(", ");
        b.append("FullyQualifiedTestName=");
        b.append(this.fullyQualifiedTestName);
        b.append(", ");
        b.append("TestOwner=");
        b.append(this.testOwner);
        b.append(", ");
        b.append("ContainerName=");
        b.append(this.containerName);
        b.append(", ");
        b.append("Priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
