package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "PipelineJobSK", 
    "PipelineId", 
    "PipelineSK", 
    "StageName", 
    "JobName", 
    "FullJobName", 
    "StrategyAttributes", 
    "StageId", 
    "JobId"})
@JsonInclude(Include.NON_NULL)
public class PipelineJob implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("PipelineJobSK")
    protected Integer pipelineJobSK;

    @JsonProperty("PipelineId")
    protected Integer pipelineId;

    @JsonProperty("PipelineSK")
    protected Integer pipelineSK;

    @JsonProperty("StageName")
    protected String stageName;

    @JsonProperty("JobName")
    protected String jobName;

    @JsonProperty("FullJobName")
    protected String fullJobName;

    @JsonProperty("StrategyAttributes")
    protected String strategyAttributes;

    @JsonProperty("StageId")
    protected String stageId;

    @JsonProperty("JobId")
    protected String jobId;

    protected PipelineJob() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer pipelineJobSK;
        private Integer pipelineId;
        private Integer pipelineSK;
        private String stageName;
        private String jobName;
        private String fullJobName;
        private String strategyAttributes;
        private String stageId;
        private String jobId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder pipelineJobSK(Integer pipelineJobSK) {
            this.pipelineJobSK = pipelineJobSK;
            this.changedFields = changedFields.add("PipelineJobSK");
            return this;
        }

        public Builder pipelineId(Integer pipelineId) {
            this.pipelineId = pipelineId;
            this.changedFields = changedFields.add("PipelineId");
            return this;
        }

        public Builder pipelineSK(Integer pipelineSK) {
            this.pipelineSK = pipelineSK;
            this.changedFields = changedFields.add("PipelineSK");
            return this;
        }

        public Builder stageName(String stageName) {
            this.stageName = stageName;
            this.changedFields = changedFields.add("StageName");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.changedFields = changedFields.add("JobName");
            return this;
        }

        public Builder fullJobName(String fullJobName) {
            this.fullJobName = fullJobName;
            this.changedFields = changedFields.add("FullJobName");
            return this;
        }

        public Builder strategyAttributes(String strategyAttributes) {
            this.strategyAttributes = strategyAttributes;
            this.changedFields = changedFields.add("StrategyAttributes");
            return this;
        }

        public Builder stageId(String stageId) {
            this.stageId = stageId;
            this.changedFields = changedFields.add("StageId");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.changedFields = changedFields.add("JobId");
            return this;
        }

        public PipelineJob build() {
            PipelineJob _x = new PipelineJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob";
            _x.projectSK = projectSK;
            _x.pipelineJobSK = pipelineJobSK;
            _x.pipelineId = pipelineId;
            _x.pipelineSK = pipelineSK;
            _x.stageName = stageName;
            _x.jobName = jobName;
            _x.fullJobName = fullJobName;
            _x.strategyAttributes = strategyAttributes;
            _x.stageId = stageId;
            _x.jobId = jobId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && pipelineJobSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(pipelineJobSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public PipelineJob withProjectSK(String projectSK) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="PipelineJobSK")
    @JsonIgnore
    public Optional<Integer> getPipelineJobSK() {
        return Optional.ofNullable(pipelineJobSK);
    }

    public PipelineJob withPipelineJobSK(Integer pipelineJobSK) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("PipelineJobSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.pipelineJobSK = pipelineJobSK;
        return _x;
    }

    @Property(name="PipelineId")
    @JsonIgnore
    public Optional<Integer> getPipelineId() {
        return Optional.ofNullable(pipelineId);
    }

    public PipelineJob withPipelineId(Integer pipelineId) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("PipelineId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.pipelineId = pipelineId;
        return _x;
    }

    @Property(name="PipelineSK")
    @JsonIgnore
    public Optional<Integer> getPipelineSK() {
        return Optional.ofNullable(pipelineSK);
    }

    public PipelineJob withPipelineSK(Integer pipelineSK) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("PipelineSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.pipelineSK = pipelineSK;
        return _x;
    }

    @Property(name="StageName")
    @JsonIgnore
    public Optional<String> getStageName() {
        return Optional.ofNullable(stageName);
    }

    public PipelineJob withStageName(String stageName) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("StageName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.stageName = stageName;
        return _x;
    }

    @Property(name="JobName")
    @JsonIgnore
    public Optional<String> getJobName() {
        return Optional.ofNullable(jobName);
    }

    public PipelineJob withJobName(String jobName) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("JobName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.jobName = jobName;
        return _x;
    }

    @Property(name="FullJobName")
    @JsonIgnore
    public Optional<String> getFullJobName() {
        return Optional.ofNullable(fullJobName);
    }

    public PipelineJob withFullJobName(String fullJobName) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("FullJobName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.fullJobName = fullJobName;
        return _x;
    }

    @Property(name="StrategyAttributes")
    @JsonIgnore
    public Optional<String> getStrategyAttributes() {
        return Optional.ofNullable(strategyAttributes);
    }

    public PipelineJob withStrategyAttributes(String strategyAttributes) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("StrategyAttributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.strategyAttributes = strategyAttributes;
        return _x;
    }

    @Property(name="StageId")
    @JsonIgnore
    public Optional<String> getStageId() {
        return Optional.ofNullable(stageId);
    }

    public PipelineJob withStageId(String stageId) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("StageId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.stageId = stageId;
        return _x;
    }

    @Property(name="JobId")
    @JsonIgnore
    public Optional<String> getJobId() {
        return Optional.ofNullable(jobId);
    }

    public PipelineJob withJobId(String jobId) {
        PipelineJob _x = _copy();
        _x.changedFields = changedFields.add("JobId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineJob");
        _x.jobId = jobId;
        return _x;
    }

    public PipelineJob withUnmappedField(String name, String value) {
        PipelineJob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PipelineJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PipelineJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PipelineJob _copy() {
        PipelineJob _x = new PipelineJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.pipelineJobSK = pipelineJobSK;
        _x.pipelineId = pipelineId;
        _x.pipelineSK = pipelineSK;
        _x.stageName = stageName;
        _x.jobName = jobName;
        _x.fullJobName = fullJobName;
        _x.strategyAttributes = strategyAttributes;
        _x.stageId = stageId;
        _x.jobId = jobId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PipelineJob[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("PipelineJobSK=");
        b.append(this.pipelineJobSK);
        b.append(", ");
        b.append("PipelineId=");
        b.append(this.pipelineId);
        b.append(", ");
        b.append("PipelineSK=");
        b.append(this.pipelineSK);
        b.append(", ");
        b.append("StageName=");
        b.append(this.stageName);
        b.append(", ");
        b.append("JobName=");
        b.append(this.jobName);
        b.append(", ");
        b.append("FullJobName=");
        b.append(this.fullJobName);
        b.append(", ");
        b.append("StrategyAttributes=");
        b.append(this.strategyAttributes);
        b.append(", ");
        b.append("StageId=");
        b.append(this.stageId);
        b.append(", ");
        b.append("JobId=");
        b.append(this.jobId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
