package microsoft.vs.analytics.v4.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "BranchSK", 
    "RepositoryId", 
    "BranchName", 
    "RepositoryVstsId", 
    "AnalyticsUpdatedDate", 
    "RepositoryUrl"})
@JsonInclude(Include.NON_NULL)
public class Branch implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Branch";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("BranchSK")
    protected Integer branchSK;

    @JsonProperty("RepositoryId")
    protected String repositoryId;

    @JsonProperty("BranchName")
    protected String branchName;

    @JsonProperty("RepositoryVstsId")
    protected String repositoryVstsId;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("RepositoryUrl")
    protected String repositoryUrl;

    protected Branch() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer branchSK;
        private String repositoryId;
        private String branchName;
        private String repositoryVstsId;
        private OffsetDateTime analyticsUpdatedDate;
        private String repositoryUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder branchSK(Integer branchSK) {
            this.branchSK = branchSK;
            this.changedFields = changedFields.add("BranchSK");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.changedFields = changedFields.add("RepositoryId");
            return this;
        }

        public Builder branchName(String branchName) {
            this.branchName = branchName;
            this.changedFields = changedFields.add("BranchName");
            return this;
        }

        public Builder repositoryVstsId(String repositoryVstsId) {
            this.repositoryVstsId = repositoryVstsId;
            this.changedFields = changedFields.add("RepositoryVstsId");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.changedFields = changedFields.add("RepositoryUrl");
            return this;
        }

        public Branch build() {
            Branch _x = new Branch();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Branch";
            _x.projectSK = projectSK;
            _x.branchSK = branchSK;
            _x.repositoryId = repositoryId;
            _x.branchName = branchName;
            _x.repositoryVstsId = repositoryVstsId;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.repositoryUrl = repositoryUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && branchSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(branchSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Branch withProjectSK(String projectSK) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="BranchSK")
    @JsonIgnore
    public Optional<Integer> getBranchSK() {
        return Optional.ofNullable(branchSK);
    }

    public Branch withBranchSK(Integer branchSK) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("BranchSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.branchSK = branchSK;
        return _x;
    }

    @Property(name="RepositoryId")
    @JsonIgnore
    public Optional<String> getRepositoryId() {
        return Optional.ofNullable(repositoryId);
    }

    public Branch withRepositoryId(String repositoryId) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("RepositoryId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.repositoryId = repositoryId;
        return _x;
    }

    @Property(name="BranchName")
    @JsonIgnore
    public Optional<String> getBranchName() {
        return Optional.ofNullable(branchName);
    }

    public Branch withBranchName(String branchName) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("BranchName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.branchName = branchName;
        return _x;
    }

    @Property(name="RepositoryVstsId")
    @JsonIgnore
    public Optional<String> getRepositoryVstsId() {
        return Optional.ofNullable(repositoryVstsId);
    }

    public Branch withRepositoryVstsId(String repositoryVstsId) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("RepositoryVstsId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.repositoryVstsId = repositoryVstsId;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public Branch withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="RepositoryUrl")
    @JsonIgnore
    public Optional<String> getRepositoryUrl() {
        return Optional.ofNullable(repositoryUrl);
    }

    public Branch withRepositoryUrl(String repositoryUrl) {
        Branch _x = _copy();
        _x.changedFields = changedFields.add("RepositoryUrl");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Branch");
        _x.repositoryUrl = repositoryUrl;
        return _x;
    }

    public Branch withUnmappedField(String name, String value) {
        Branch _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Branch patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Branch _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Branch put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Branch _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Branch _copy() {
        Branch _x = new Branch();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.branchSK = branchSK;
        _x.repositoryId = repositoryId;
        _x.branchName = branchName;
        _x.repositoryVstsId = repositoryVstsId;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.repositoryUrl = repositoryUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Branch[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("BranchSK=");
        b.append(this.branchSK);
        b.append(", ");
        b.append("RepositoryId=");
        b.append(this.repositoryId);
        b.append(", ");
        b.append("BranchName=");
        b.append(this.branchName);
        b.append(", ");
        b.append("RepositoryVstsId=");
        b.append(this.repositoryVstsId);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("RepositoryUrl=");
        b.append(this.repositoryUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
