package microsoft.vs.analytics.v3.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.collection.request.TestRunCollectionRequest;

public final class TestRuns extends TestRunCollectionRequest {

    public TestRuns(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public PipelineRuns pipelineRun() {
        return new PipelineRuns(contextPath.addSegment("PipelineRun"));
    }

    public Pipelines pipeline() {
        return new Pipelines(contextPath.addSegment("Pipeline"));
    }

    public Branches branch() {
        return new Branches(contextPath.addSegment("Branch"));
    }

    public Dates completedOn() {
        return new Dates(contextPath.addSegment("CompletedOn"));
    }

    public Dates startedOn() {
        return new Dates(contextPath.addSegment("StartedOn"));
    }
}
