package microsoft.vs.analytics.v3.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.collection.request.TestPointCollectionRequest;

public final class TestPoints extends TestPointCollectionRequest {

    public TestPoints(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Dates changedOn() {
        return new Dates(contextPath.addSegment("ChangedOn"));
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public TestSuites testSuite() {
        return new TestSuites(contextPath.addSegment("TestSuite"));
    }

    public TestConfigurations testConfiguration() {
        return new TestConfigurations(contextPath.addSegment("TestConfiguration"));
    }

    public WorkItems testCase() {
        return new WorkItems(contextPath.addSegment("TestCase"));
    }

    public Users tester() {
        return new Users(contextPath.addSegment("Tester"));
    }

    public Users assignedTo() {
        return new Users(contextPath.addSegment("AssignedTo"));
    }
}
