package microsoft.vs.analytics.v3.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SourceWorkflow implements Enum {

    @JsonProperty("Build")
    BUILD("Build", "1"),

    @JsonProperty("Release")
    RELEASE("Release", "2"),

    @JsonProperty("Manual")
    MANUAL("Manual", "3");

    private final String name;
    private final String value;

    private SourceWorkflow(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
