package microsoft.vs.analytics.v3.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PredictModel implements Enum {

    @JsonProperty("WorkItemCompletedTime")
    WORK_ITEM_COMPLETED_TIME("WorkItemCompletedTime", "0");

    private final String name;
    private final String value;

    private PredictModel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
