package microsoft.vs.analytics.v3.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PipelineRunReason implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Manual")
    MANUAL("Manual", "1"),

    @JsonProperty("IndividualCI")
    INDIVIDUAL_CI("IndividualCI", "2"),

    @JsonProperty("BatchedCI")
    BATCHED_CI("BatchedCI", "4"),

    @JsonProperty("Schedule")
    SCHEDULE("Schedule", "8"),

    @JsonProperty("UserCreated")
    USER_CREATED("UserCreated", "32"),

    @JsonProperty("ValidateShelveset")
    VALIDATE_SHELVESET("ValidateShelveset", "64"),

    @JsonProperty("CheckInShelveset")
    CHECK_IN_SHELVESET("CheckInShelveset", "128"),

    @JsonProperty("PullRequest")
    PULL_REQUEST("PullRequest", "256"),

    @JsonProperty("PipelineRunCompletion")
    PIPELINE_RUN_COMPLETION("PipelineRunCompletion", "512");

    private final String name;
    private final String value;

    private PipelineRunReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
