package microsoft.vs.analytics.v3.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Period implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Day")
    DAY("Day", "1"),

    @JsonProperty("WeekEndingOnSunday")
    WEEK_ENDING_ON_SUNDAY("WeekEndingOnSunday", "2"),

    @JsonProperty("WeekEndingOnMonday")
    WEEK_ENDING_ON_MONDAY("WeekEndingOnMonday", "4"),

    @JsonProperty("WeekEndingOnTuesday")
    WEEK_ENDING_ON_TUESDAY("WeekEndingOnTuesday", "8"),

    @JsonProperty("WeekEndingOnWednesday")
    WEEK_ENDING_ON_WEDNESDAY("WeekEndingOnWednesday", "16"),

    @JsonProperty("WeekEndingOnThursday")
    WEEK_ENDING_ON_THURSDAY("WeekEndingOnThursday", "32"),

    @JsonProperty("WeekEndingOnFriday")
    WEEK_ENDING_ON_FRIDAY("WeekEndingOnFriday", "64"),

    @JsonProperty("WeekEndingOnSaturday")
    WEEK_ENDING_ON_SATURDAY("WeekEndingOnSaturday", "128"),

    @JsonProperty("Month")
    MONTH("Month", "256"),

    @JsonProperty("Quarter")
    QUARTER("Quarter", "512"),

    @JsonProperty("Year")
    YEAR("Year", "1024"),

    @JsonProperty("All")
    ALL("All", "2047");

    private final String name;
    private final String value;

    private Period(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
