package microsoft.vs.analytics.v3.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BoardColumnSplit implements Enum {

    @JsonProperty("Doing")
    DOING("Doing", "0"),

    @JsonProperty("Done")
    DONE("Done", "1"),

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "2");

    private final String name;
    private final String value;

    private BoardColumnSplit(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
