package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.TestRun;

@JsonIgnoreType
public class TestRunRequest extends EntityRequest<TestRun> {

    public TestRunRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestRun.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public PipelineRunRequest pipelineRun() {
        return new PipelineRunRequest(contextPath.addSegment("PipelineRun"), Optional.empty());
    }

    public PipelineRequest pipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), Optional.empty());
    }

    public BranchRequest branch() {
        return new BranchRequest(contextPath.addSegment("Branch"), Optional.empty());
    }

    public CalendarDateRequest completedOn() {
        return new CalendarDateRequest(contextPath.addSegment("CompletedOn"), Optional.empty());
    }

    public CalendarDateRequest startedOn() {
        return new CalendarDateRequest(contextPath.addSegment("StartedOn"), Optional.empty());
    }

}
