package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.TestResultDaily;

@JsonIgnoreType
public class TestResultDailyRequest extends EntityRequest<TestResultDaily> {

    public TestResultDailyRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestResultDaily.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public TestRequest test() {
        return new TestRequest(contextPath.addSegment("Test"), Optional.empty());
    }

    public PipelineRequest pipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), Optional.empty());
    }

    public BranchRequest branch() {
        return new BranchRequest(contextPath.addSegment("Branch"), Optional.empty());
    }

    public CalendarDateRequest date() {
        return new CalendarDateRequest(contextPath.addSegment("Date"), Optional.empty());
    }

}
