package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.TestPointHistorySnapshot;

@JsonIgnoreType
public class TestPointHistorySnapshotRequest extends EntityRequest<TestPointHistorySnapshot> {

    public TestPointHistorySnapshotRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestPointHistorySnapshot.class, contextPath, value, false);
    }

    public CalendarDateRequest date() {
        return new CalendarDateRequest(contextPath.addSegment("Date"), Optional.empty());
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public TestSuiteRequest testSuite() {
        return new TestSuiteRequest(contextPath.addSegment("TestSuite"), Optional.empty());
    }

    public TestConfigurationRequest testConfiguration() {
        return new TestConfigurationRequest(contextPath.addSegment("TestConfiguration"), Optional.empty());
    }

    public WorkItemRequest testCase() {
        return new WorkItemRequest(contextPath.addSegment("TestCase"), Optional.empty());
    }

    public UserRequest tester() {
        return new UserRequest(contextPath.addSegment("Tester"), Optional.empty());
    }

    public UserRequest assignedTo() {
        return new UserRequest(contextPath.addSegment("AssignedTo"), Optional.empty());
    }

}
