package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.TestConfiguration;

@JsonIgnoreType
public class TestConfigurationRequest extends EntityRequest<TestConfiguration> {

    public TestConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(TestConfiguration.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

}
