package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.Process;

@JsonIgnoreType
public class ProcessRequest extends EntityRequest<Process> {

    public ProcessRequest(ContextPath contextPath, Optional<Object> value) {
        super(Process.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public TeamRequest team() {
        return new TeamRequest(contextPath.addSegment("Team"), Optional.empty());
    }

}
