package microsoft.vs.analytics.v3.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.Iteration;
import microsoft.vs.analytics.v3.model.entity.collection.request.TeamCollectionRequest;

@JsonIgnoreType
public class IterationRequest extends EntityRequest<Iteration> {

    public IterationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Iteration.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

}
