package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.WorkItemRevision;
import microsoft.vs.analytics.v3.model.entity.request.BoardLocationRequest;
import microsoft.vs.analytics.v3.model.entity.request.ProcessRequest;
import microsoft.vs.analytics.v3.model.entity.request.TagRequest;
import microsoft.vs.analytics.v3.model.entity.request.TeamRequest;
import microsoft.vs.analytics.v3.model.entity.request.WorkItemRevisionRequest;

public class WorkItemRevisionCollectionRequest extends CollectionPageEntityRequest<WorkItemRevision, WorkItemRevisionRequest>{

    protected ContextPath contextPath;

    public WorkItemRevisionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkItemRevision.class, cp -> new WorkItemRevisionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BoardLocationCollectionRequest boardLocations() {
        return new BoardLocationCollectionRequest(contextPath.addSegment("BoardLocations"), Optional.empty());
    }

    public BoardLocationRequest boardLocations(Integer boardLocationSK) {
        return new BoardLocationRequest(contextPath.addSegment("BoardLocations").addKeys(new NameValue(boardLocationSK.toString())), Optional.empty());
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

    public ProcessCollectionRequest processes() {
        return new ProcessCollectionRequest(contextPath.addSegment("Processes"), Optional.empty());
    }

    public ProcessRequest processes(Integer processSK) {
        return new ProcessRequest(contextPath.addSegment("Processes").addKeys(new NameValue(processSK.toString())), Optional.empty());
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(contextPath.addSegment("Tags"), Optional.empty());
    }

    public TagRequest tags(Integer tagSK) {
        return new TagRequest(contextPath.addSegment("Tags").addKeys(new NameValue(tagSK.toString())), Optional.empty());
    }

}
