package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.WorkItemBoardSnapshot;
import microsoft.vs.analytics.v3.model.entity.request.TagRequest;
import microsoft.vs.analytics.v3.model.entity.request.WorkItemBoardSnapshotRequest;

public class WorkItemBoardSnapshotCollectionRequest extends CollectionPageEntityRequest<WorkItemBoardSnapshot, WorkItemBoardSnapshotRequest>{

    protected ContextPath contextPath;

    public WorkItemBoardSnapshotCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkItemBoardSnapshot.class, cp -> new WorkItemBoardSnapshotRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(contextPath.addSegment("Tags"), Optional.empty());
    }

    public TagRequest tags(Integer tagSK) {
        return new TagRequest(contextPath.addSegment("Tags").addKeys(new NameValue(tagSK.toString())), Optional.empty());
    }

}
