package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.Project;
import microsoft.vs.analytics.v3.model.entity.request.AreaRequest;
import microsoft.vs.analytics.v3.model.entity.request.IterationRequest;
import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.entity.request.TeamRequest;

public class ProjectCollectionRequest extends CollectionPageEntityRequest<Project, ProjectRequest>{

    protected ContextPath contextPath;

    public ProjectCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Project.class, cp -> new ProjectRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AreaCollectionRequest areas() {
        return new AreaCollectionRequest(contextPath.addSegment("Areas"), Optional.empty());
    }

    public AreaRequest areas(String areaSK) {
        return new AreaRequest(contextPath.addSegment("Areas").addKeys(new NameValue(areaSK.toString())), Optional.empty());
    }

    public IterationCollectionRequest iterations() {
        return new IterationCollectionRequest(contextPath.addSegment("Iterations"), Optional.empty());
    }

    public IterationRequest iterations(String iterationSK) {
        return new IterationRequest(contextPath.addSegment("Iterations").addKeys(new NameValue(iterationSK.toString())), Optional.empty());
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

}
