package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.CalendarDate;
import microsoft.vs.analytics.v3.model.entity.request.CalendarDateRequest;

public class CalendarDateCollectionRequest extends CollectionPageEntityRequest<CalendarDate, CalendarDateRequest>{

    protected ContextPath contextPath;

    public CalendarDateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CalendarDate.class, cp -> new CalendarDateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
