package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.BoardLocation;
import microsoft.vs.analytics.v3.model.entity.request.BoardLocationRequest;
import microsoft.vs.analytics.v3.model.entity.request.WorkItemRequest;

public class BoardLocationCollectionRequest extends CollectionPageEntityRequest<BoardLocation, BoardLocationRequest>{

    protected ContextPath contextPath;

    public BoardLocationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, BoardLocation.class, cp -> new BoardLocationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkItemCollectionRequest workItems() {
        return new WorkItemCollectionRequest(contextPath.addSegment("WorkItems"), Optional.empty());
    }

    public WorkItemRequest workItems(Integer workItemId) {
        return new WorkItemRequest(contextPath.addSegment("WorkItems").addKeys(new NameValue(workItemId.toString())), Optional.empty());
    }

}
