package microsoft.vs.analytics.v3.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.Area;
import microsoft.vs.analytics.v3.model.entity.request.AreaRequest;
import microsoft.vs.analytics.v3.model.entity.request.TeamRequest;

public class AreaCollectionRequest extends CollectionPageEntityRequest<Area, AreaRequest>{

    protected ContextPath contextPath;

    public AreaCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Area.class, cp -> new AreaRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

}
