package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.entity.request.WorkItemRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "WorkItemLinkSK", 
    "SourceWorkItemId", 
    "TargetWorkItemId", 
    "CreatedDate", 
    "DeletedDate", 
    "Comment", 
    "LinkTypeId", 
    "LinkTypeReferenceName", 
    "LinkTypeName", 
    "LinkTypeIsAcyclic", 
    "LinkTypeIsDirectional", 
    "AnalyticsUpdatedDate", 
    "ProjectSK"})
@JsonInclude(Include.NON_NULL)
public class WorkItemLink implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("WorkItemLinkSK")
    protected Integer workItemLinkSK;

    @JsonProperty("SourceWorkItemId")
    protected Integer sourceWorkItemId;

    @JsonProperty("TargetWorkItemId")
    protected Integer targetWorkItemId;

    @JsonProperty("CreatedDate")
    protected OffsetDateTime createdDate;

    @JsonProperty("DeletedDate")
    protected OffsetDateTime deletedDate;

    @JsonProperty("Comment")
    protected String comment;

    @JsonProperty("LinkTypeId")
    protected Integer linkTypeId;

    @JsonProperty("LinkTypeReferenceName")
    protected String linkTypeReferenceName;

    @JsonProperty("LinkTypeName")
    protected String linkTypeName;

    @JsonProperty("LinkTypeIsAcyclic")
    protected Boolean linkTypeIsAcyclic;

    @JsonProperty("LinkTypeIsDirectional")
    protected Boolean linkTypeIsDirectional;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    protected WorkItemLink() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer workItemLinkSK;
        private Integer sourceWorkItemId;
        private Integer targetWorkItemId;
        private OffsetDateTime createdDate;
        private OffsetDateTime deletedDate;
        private String comment;
        private Integer linkTypeId;
        private String linkTypeReferenceName;
        private String linkTypeName;
        private Boolean linkTypeIsAcyclic;
        private Boolean linkTypeIsDirectional;
        private OffsetDateTime analyticsUpdatedDate;
        private String projectSK;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder workItemLinkSK(Integer workItemLinkSK) {
            this.workItemLinkSK = workItemLinkSK;
            this.changedFields = changedFields.add("WorkItemLinkSK");
            return this;
        }

        public Builder sourceWorkItemId(Integer sourceWorkItemId) {
            this.sourceWorkItemId = sourceWorkItemId;
            this.changedFields = changedFields.add("SourceWorkItemId");
            return this;
        }

        public Builder targetWorkItemId(Integer targetWorkItemId) {
            this.targetWorkItemId = targetWorkItemId;
            this.changedFields = changedFields.add("TargetWorkItemId");
            return this;
        }

        public Builder createdDate(OffsetDateTime createdDate) {
            this.createdDate = createdDate;
            this.changedFields = changedFields.add("CreatedDate");
            return this;
        }

        public Builder deletedDate(OffsetDateTime deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("DeletedDate");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("Comment");
            return this;
        }

        public Builder linkTypeId(Integer linkTypeId) {
            this.linkTypeId = linkTypeId;
            this.changedFields = changedFields.add("LinkTypeId");
            return this;
        }

        public Builder linkTypeReferenceName(String linkTypeReferenceName) {
            this.linkTypeReferenceName = linkTypeReferenceName;
            this.changedFields = changedFields.add("LinkTypeReferenceName");
            return this;
        }

        public Builder linkTypeName(String linkTypeName) {
            this.linkTypeName = linkTypeName;
            this.changedFields = changedFields.add("LinkTypeName");
            return this;
        }

        public Builder linkTypeIsAcyclic(Boolean linkTypeIsAcyclic) {
            this.linkTypeIsAcyclic = linkTypeIsAcyclic;
            this.changedFields = changedFields.add("LinkTypeIsAcyclic");
            return this;
        }

        public Builder linkTypeIsDirectional(Boolean linkTypeIsDirectional) {
            this.linkTypeIsDirectional = linkTypeIsDirectional;
            this.changedFields = changedFields.add("LinkTypeIsDirectional");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public WorkItemLink build() {
            WorkItemLink _x = new WorkItemLink();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink";
            _x.workItemLinkSK = workItemLinkSK;
            _x.sourceWorkItemId = sourceWorkItemId;
            _x.targetWorkItemId = targetWorkItemId;
            _x.createdDate = createdDate;
            _x.deletedDate = deletedDate;
            _x.comment = comment;
            _x.linkTypeId = linkTypeId;
            _x.linkTypeReferenceName = linkTypeReferenceName;
            _x.linkTypeName = linkTypeName;
            _x.linkTypeIsAcyclic = linkTypeIsAcyclic;
            _x.linkTypeIsDirectional = linkTypeIsDirectional;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.projectSK = projectSK;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && workItemLinkSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(workItemLinkSK.toString()));
        }
    }

    @Property(name="WorkItemLinkSK")
    @JsonIgnore
    public Optional<Integer> getWorkItemLinkSK() {
        return Optional.ofNullable(workItemLinkSK);
    }

    public WorkItemLink withWorkItemLinkSK(Integer workItemLinkSK) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("WorkItemLinkSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.workItemLinkSK = workItemLinkSK;
        return _x;
    }

    @Property(name="SourceWorkItemId")
    @JsonIgnore
    public Optional<Integer> getSourceWorkItemId() {
        return Optional.ofNullable(sourceWorkItemId);
    }

    public WorkItemLink withSourceWorkItemId(Integer sourceWorkItemId) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("SourceWorkItemId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.sourceWorkItemId = sourceWorkItemId;
        return _x;
    }

    @Property(name="TargetWorkItemId")
    @JsonIgnore
    public Optional<Integer> getTargetWorkItemId() {
        return Optional.ofNullable(targetWorkItemId);
    }

    public WorkItemLink withTargetWorkItemId(Integer targetWorkItemId) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("TargetWorkItemId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.targetWorkItemId = targetWorkItemId;
        return _x;
    }

    @Property(name="CreatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDate() {
        return Optional.ofNullable(createdDate);
    }

    public WorkItemLink withCreatedDate(OffsetDateTime createdDate) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("CreatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.createdDate = createdDate;
        return _x;
    }

    @Property(name="DeletedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public WorkItemLink withDeletedDate(OffsetDateTime deletedDate) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("DeletedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="Comment")
    @JsonIgnore
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    public WorkItemLink withComment(String comment) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("Comment");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.comment = comment;
        return _x;
    }

    @Property(name="LinkTypeId")
    @JsonIgnore
    public Optional<Integer> getLinkTypeId() {
        return Optional.ofNullable(linkTypeId);
    }

    public WorkItemLink withLinkTypeId(Integer linkTypeId) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("LinkTypeId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.linkTypeId = linkTypeId;
        return _x;
    }

    @Property(name="LinkTypeReferenceName")
    @JsonIgnore
    public Optional<String> getLinkTypeReferenceName() {
        return Optional.ofNullable(linkTypeReferenceName);
    }

    public WorkItemLink withLinkTypeReferenceName(String linkTypeReferenceName) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("LinkTypeReferenceName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.linkTypeReferenceName = linkTypeReferenceName;
        return _x;
    }

    @Property(name="LinkTypeName")
    @JsonIgnore
    public Optional<String> getLinkTypeName() {
        return Optional.ofNullable(linkTypeName);
    }

    public WorkItemLink withLinkTypeName(String linkTypeName) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("LinkTypeName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.linkTypeName = linkTypeName;
        return _x;
    }

    @Property(name="LinkTypeIsAcyclic")
    @JsonIgnore
    public Optional<Boolean> getLinkTypeIsAcyclic() {
        return Optional.ofNullable(linkTypeIsAcyclic);
    }

    public WorkItemLink withLinkTypeIsAcyclic(Boolean linkTypeIsAcyclic) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("LinkTypeIsAcyclic");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.linkTypeIsAcyclic = linkTypeIsAcyclic;
        return _x;
    }

    @Property(name="LinkTypeIsDirectional")
    @JsonIgnore
    public Optional<Boolean> getLinkTypeIsDirectional() {
        return Optional.ofNullable(linkTypeIsDirectional);
    }

    public WorkItemLink withLinkTypeIsDirectional(Boolean linkTypeIsDirectional) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("LinkTypeIsDirectional");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.linkTypeIsDirectional = linkTypeIsDirectional;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public WorkItemLink withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public WorkItemLink withProjectSK(String projectSK) {
        WorkItemLink _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink");
        _x.projectSK = projectSK;
        return _x;
    }

    public WorkItemLink withUnmappedField(String name, String value) {
        WorkItemLink _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="SourceWorkItem")
    @JsonIgnore
    public WorkItemRequest getSourceWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("SourceWorkItem"), RequestHelper.getValue(unmappedFields, "SourceWorkItem"));
    }

    @NavigationProperty(name="TargetWorkItem")
    @JsonIgnore
    public WorkItemRequest getTargetWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TargetWorkItem"), RequestHelper.getValue(unmappedFields, "TargetWorkItem"));
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkItemLink patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkItemLink _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkItemLink put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkItemLink _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkItemLink _copy() {
        WorkItemLink _x = new WorkItemLink();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.workItemLinkSK = workItemLinkSK;
        _x.sourceWorkItemId = sourceWorkItemId;
        _x.targetWorkItemId = targetWorkItemId;
        _x.createdDate = createdDate;
        _x.deletedDate = deletedDate;
        _x.comment = comment;
        _x.linkTypeId = linkTypeId;
        _x.linkTypeReferenceName = linkTypeReferenceName;
        _x.linkTypeName = linkTypeName;
        _x.linkTypeIsAcyclic = linkTypeIsAcyclic;
        _x.linkTypeIsDirectional = linkTypeIsDirectional;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.projectSK = projectSK;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkItemLink[");
        b.append("WorkItemLinkSK=");
        b.append(this.workItemLinkSK);
        b.append(", ");
        b.append("SourceWorkItemId=");
        b.append(this.sourceWorkItemId);
        b.append(", ");
        b.append("TargetWorkItemId=");
        b.append(this.targetWorkItemId);
        b.append(", ");
        b.append("CreatedDate=");
        b.append(this.createdDate);
        b.append(", ");
        b.append("DeletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("Comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("LinkTypeId=");
        b.append(this.linkTypeId);
        b.append(", ");
        b.append("LinkTypeReferenceName=");
        b.append(this.linkTypeReferenceName);
        b.append(", ");
        b.append("LinkTypeName=");
        b.append(this.linkTypeName);
        b.append(", ");
        b.append("LinkTypeIsAcyclic=");
        b.append(this.linkTypeIsAcyclic);
        b.append(", ");
        b.append("LinkTypeIsDirectional=");
        b.append(this.linkTypeIsDirectional);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
