package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.BranchRequest;
import microsoft.vs.analytics.v3.model.entity.request.CalendarDateRequest;
import microsoft.vs.analytics.v3.model.entity.request.PipelineRequest;
import microsoft.vs.analytics.v3.model.entity.request.PipelineRunRequest;
import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.enums.SourceWorkflow;
import microsoft.vs.analytics.v3.model.enums.TestRunType;

@JsonPropertyOrder({
    "@odata.type", 
    "AnalyticsUpdatedDate", 
    "ProjectSK", 
    "TestRunSK", 
    "TestRunId", 
    "Title", 
    "IsAutomated", 
    "TestRunType", 
    "Workflow", 
    "PipelineRunSK", 
    "PipelineSK", 
    "BranchSK", 
    "CompletedDateSK", 
    "CompletedDate", 
    "StartedDateSK", 
    "StartedDate", 
    "RunDurationSeconds", 
    "ResultDurationSeconds", 
    "ResultCount", 
    "ResultPassCount", 
    "ResultFailCount", 
    "ResultNoneCount", 
    "ResultInconclusiveCount", 
    "ResultTimeoutCount", 
    "ResultAbortedCount", 
    "ResultBlockedCount", 
    "ResultNotExecutedCount", 
    "ResultWarningCount", 
    "ResultErrorCount", 
    "ResultNotApplicableCount", 
    "ResultNotImpactedCount", 
    "HasDetail", 
    "ReleaseId", 
    "ReleaseEnvironmentId", 
    "ReleasePipelineId", 
    "ReleaseStageId", 
    "ResultFlakyCount"})
@JsonInclude(Include.NON_NULL)
public class TestRun implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.TestRun";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestRunSK")
    protected Integer testRunSK;

    @JsonProperty("TestRunId")
    protected Integer testRunId;

    @JsonProperty("Title")
    protected String title;

    @JsonProperty("IsAutomated")
    protected Boolean isAutomated;

    @JsonProperty("TestRunType")
    protected TestRunType testRunType;

    @JsonProperty("Workflow")
    protected SourceWorkflow workflow;

    @JsonProperty("PipelineRunSK")
    protected Integer pipelineRunSK;

    @JsonProperty("PipelineSK")
    protected Integer pipelineSK;

    @JsonProperty("BranchSK")
    protected Integer branchSK;

    @JsonProperty("CompletedDateSK")
    protected Integer completedDateSK;

    @JsonProperty("CompletedDate")
    protected OffsetDateTime completedDate;

    @JsonProperty("StartedDateSK")
    protected Integer startedDateSK;

    @JsonProperty("StartedDate")
    protected OffsetDateTime startedDate;

    @JsonProperty("RunDurationSeconds")
    protected BigDecimal runDurationSeconds;

    @JsonProperty("ResultDurationSeconds")
    protected BigDecimal resultDurationSeconds;

    @JsonProperty("ResultCount")
    protected Integer resultCount;

    @JsonProperty("ResultPassCount")
    protected Integer resultPassCount;

    @JsonProperty("ResultFailCount")
    protected Integer resultFailCount;

    @JsonProperty("ResultNoneCount")
    protected Integer resultNoneCount;

    @JsonProperty("ResultInconclusiveCount")
    protected Integer resultInconclusiveCount;

    @JsonProperty("ResultTimeoutCount")
    protected Integer resultTimeoutCount;

    @JsonProperty("ResultAbortedCount")
    protected Integer resultAbortedCount;

    @JsonProperty("ResultBlockedCount")
    protected Integer resultBlockedCount;

    @JsonProperty("ResultNotExecutedCount")
    protected Integer resultNotExecutedCount;

    @JsonProperty("ResultWarningCount")
    protected Integer resultWarningCount;

    @JsonProperty("ResultErrorCount")
    protected Integer resultErrorCount;

    @JsonProperty("ResultNotApplicableCount")
    protected Integer resultNotApplicableCount;

    @JsonProperty("ResultNotImpactedCount")
    protected Integer resultNotImpactedCount;

    @JsonProperty("HasDetail")
    protected Boolean hasDetail;

    @JsonProperty("ReleaseId")
    protected Integer releaseId;

    @JsonProperty("ReleaseEnvironmentId")
    protected Integer releaseEnvironmentId;

    @JsonProperty("ReleasePipelineId")
    protected Integer releasePipelineId;

    @JsonProperty("ReleaseStageId")
    protected Integer releaseStageId;

    @JsonProperty("ResultFlakyCount")
    protected Integer resultFlakyCount;

    protected TestRun() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime analyticsUpdatedDate;
        private String projectSK;
        private Integer testRunSK;
        private Integer testRunId;
        private String title;
        private Boolean isAutomated;
        private TestRunType testRunType;
        private SourceWorkflow workflow;
        private Integer pipelineRunSK;
        private Integer pipelineSK;
        private Integer branchSK;
        private Integer completedDateSK;
        private OffsetDateTime completedDate;
        private Integer startedDateSK;
        private OffsetDateTime startedDate;
        private BigDecimal runDurationSeconds;
        private BigDecimal resultDurationSeconds;
        private Integer resultCount;
        private Integer resultPassCount;
        private Integer resultFailCount;
        private Integer resultNoneCount;
        private Integer resultInconclusiveCount;
        private Integer resultTimeoutCount;
        private Integer resultAbortedCount;
        private Integer resultBlockedCount;
        private Integer resultNotExecutedCount;
        private Integer resultWarningCount;
        private Integer resultErrorCount;
        private Integer resultNotApplicableCount;
        private Integer resultNotImpactedCount;
        private Boolean hasDetail;
        private Integer releaseId;
        private Integer releaseEnvironmentId;
        private Integer releasePipelineId;
        private Integer releaseStageId;
        private Integer resultFlakyCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testRunSK(Integer testRunSK) {
            this.testRunSK = testRunSK;
            this.changedFields = changedFields.add("TestRunSK");
            return this;
        }

        public Builder testRunId(Integer testRunId) {
            this.testRunId = testRunId;
            this.changedFields = changedFields.add("TestRunId");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("Title");
            return this;
        }

        public Builder isAutomated(Boolean isAutomated) {
            this.isAutomated = isAutomated;
            this.changedFields = changedFields.add("IsAutomated");
            return this;
        }

        public Builder testRunType(TestRunType testRunType) {
            this.testRunType = testRunType;
            this.changedFields = changedFields.add("TestRunType");
            return this;
        }

        public Builder workflow(SourceWorkflow workflow) {
            this.workflow = workflow;
            this.changedFields = changedFields.add("Workflow");
            return this;
        }

        public Builder pipelineRunSK(Integer pipelineRunSK) {
            this.pipelineRunSK = pipelineRunSK;
            this.changedFields = changedFields.add("PipelineRunSK");
            return this;
        }

        public Builder pipelineSK(Integer pipelineSK) {
            this.pipelineSK = pipelineSK;
            this.changedFields = changedFields.add("PipelineSK");
            return this;
        }

        public Builder branchSK(Integer branchSK) {
            this.branchSK = branchSK;
            this.changedFields = changedFields.add("BranchSK");
            return this;
        }

        public Builder completedDateSK(Integer completedDateSK) {
            this.completedDateSK = completedDateSK;
            this.changedFields = changedFields.add("CompletedDateSK");
            return this;
        }

        public Builder completedDate(OffsetDateTime completedDate) {
            this.completedDate = completedDate;
            this.changedFields = changedFields.add("CompletedDate");
            return this;
        }

        public Builder startedDateSK(Integer startedDateSK) {
            this.startedDateSK = startedDateSK;
            this.changedFields = changedFields.add("StartedDateSK");
            return this;
        }

        public Builder startedDate(OffsetDateTime startedDate) {
            this.startedDate = startedDate;
            this.changedFields = changedFields.add("StartedDate");
            return this;
        }

        public Builder runDurationSeconds(BigDecimal runDurationSeconds) {
            this.runDurationSeconds = runDurationSeconds;
            this.changedFields = changedFields.add("RunDurationSeconds");
            return this;
        }

        public Builder resultDurationSeconds(BigDecimal resultDurationSeconds) {
            this.resultDurationSeconds = resultDurationSeconds;
            this.changedFields = changedFields.add("ResultDurationSeconds");
            return this;
        }

        public Builder resultCount(Integer resultCount) {
            this.resultCount = resultCount;
            this.changedFields = changedFields.add("ResultCount");
            return this;
        }

        public Builder resultPassCount(Integer resultPassCount) {
            this.resultPassCount = resultPassCount;
            this.changedFields = changedFields.add("ResultPassCount");
            return this;
        }

        public Builder resultFailCount(Integer resultFailCount) {
            this.resultFailCount = resultFailCount;
            this.changedFields = changedFields.add("ResultFailCount");
            return this;
        }

        public Builder resultNoneCount(Integer resultNoneCount) {
            this.resultNoneCount = resultNoneCount;
            this.changedFields = changedFields.add("ResultNoneCount");
            return this;
        }

        public Builder resultInconclusiveCount(Integer resultInconclusiveCount) {
            this.resultInconclusiveCount = resultInconclusiveCount;
            this.changedFields = changedFields.add("ResultInconclusiveCount");
            return this;
        }

        public Builder resultTimeoutCount(Integer resultTimeoutCount) {
            this.resultTimeoutCount = resultTimeoutCount;
            this.changedFields = changedFields.add("ResultTimeoutCount");
            return this;
        }

        public Builder resultAbortedCount(Integer resultAbortedCount) {
            this.resultAbortedCount = resultAbortedCount;
            this.changedFields = changedFields.add("ResultAbortedCount");
            return this;
        }

        public Builder resultBlockedCount(Integer resultBlockedCount) {
            this.resultBlockedCount = resultBlockedCount;
            this.changedFields = changedFields.add("ResultBlockedCount");
            return this;
        }

        public Builder resultNotExecutedCount(Integer resultNotExecutedCount) {
            this.resultNotExecutedCount = resultNotExecutedCount;
            this.changedFields = changedFields.add("ResultNotExecutedCount");
            return this;
        }

        public Builder resultWarningCount(Integer resultWarningCount) {
            this.resultWarningCount = resultWarningCount;
            this.changedFields = changedFields.add("ResultWarningCount");
            return this;
        }

        public Builder resultErrorCount(Integer resultErrorCount) {
            this.resultErrorCount = resultErrorCount;
            this.changedFields = changedFields.add("ResultErrorCount");
            return this;
        }

        public Builder resultNotApplicableCount(Integer resultNotApplicableCount) {
            this.resultNotApplicableCount = resultNotApplicableCount;
            this.changedFields = changedFields.add("ResultNotApplicableCount");
            return this;
        }

        public Builder resultNotImpactedCount(Integer resultNotImpactedCount) {
            this.resultNotImpactedCount = resultNotImpactedCount;
            this.changedFields = changedFields.add("ResultNotImpactedCount");
            return this;
        }

        public Builder hasDetail(Boolean hasDetail) {
            this.hasDetail = hasDetail;
            this.changedFields = changedFields.add("HasDetail");
            return this;
        }

        public Builder releaseId(Integer releaseId) {
            this.releaseId = releaseId;
            this.changedFields = changedFields.add("ReleaseId");
            return this;
        }

        public Builder releaseEnvironmentId(Integer releaseEnvironmentId) {
            this.releaseEnvironmentId = releaseEnvironmentId;
            this.changedFields = changedFields.add("ReleaseEnvironmentId");
            return this;
        }

        public Builder releasePipelineId(Integer releasePipelineId) {
            this.releasePipelineId = releasePipelineId;
            this.changedFields = changedFields.add("ReleasePipelineId");
            return this;
        }

        public Builder releaseStageId(Integer releaseStageId) {
            this.releaseStageId = releaseStageId;
            this.changedFields = changedFields.add("ReleaseStageId");
            return this;
        }

        public Builder resultFlakyCount(Integer resultFlakyCount) {
            this.resultFlakyCount = resultFlakyCount;
            this.changedFields = changedFields.add("ResultFlakyCount");
            return this;
        }

        public TestRun build() {
            TestRun _x = new TestRun();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.TestRun";
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.projectSK = projectSK;
            _x.testRunSK = testRunSK;
            _x.testRunId = testRunId;
            _x.title = title;
            _x.isAutomated = isAutomated;
            _x.testRunType = testRunType;
            _x.workflow = workflow;
            _x.pipelineRunSK = pipelineRunSK;
            _x.pipelineSK = pipelineSK;
            _x.branchSK = branchSK;
            _x.completedDateSK = completedDateSK;
            _x.completedDate = completedDate;
            _x.startedDateSK = startedDateSK;
            _x.startedDate = startedDate;
            _x.runDurationSeconds = runDurationSeconds;
            _x.resultDurationSeconds = resultDurationSeconds;
            _x.resultCount = resultCount;
            _x.resultPassCount = resultPassCount;
            _x.resultFailCount = resultFailCount;
            _x.resultNoneCount = resultNoneCount;
            _x.resultInconclusiveCount = resultInconclusiveCount;
            _x.resultTimeoutCount = resultTimeoutCount;
            _x.resultAbortedCount = resultAbortedCount;
            _x.resultBlockedCount = resultBlockedCount;
            _x.resultNotExecutedCount = resultNotExecutedCount;
            _x.resultWarningCount = resultWarningCount;
            _x.resultErrorCount = resultErrorCount;
            _x.resultNotApplicableCount = resultNotApplicableCount;
            _x.resultNotImpactedCount = resultNotImpactedCount;
            _x.hasDetail = hasDetail;
            _x.releaseId = releaseId;
            _x.releaseEnvironmentId = releaseEnvironmentId;
            _x.releasePipelineId = releasePipelineId;
            _x.releaseStageId = releaseStageId;
            _x.resultFlakyCount = resultFlakyCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && testRunSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(testRunSK.toString()));
        }
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public TestRun withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public TestRun withProjectSK(String projectSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestRunSK")
    @JsonIgnore
    public Optional<Integer> getTestRunSK() {
        return Optional.ofNullable(testRunSK);
    }

    public TestRun withTestRunSK(Integer testRunSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("TestRunSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.testRunSK = testRunSK;
        return _x;
    }

    @Property(name="TestRunId")
    @JsonIgnore
    public Optional<Integer> getTestRunId() {
        return Optional.ofNullable(testRunId);
    }

    public TestRun withTestRunId(Integer testRunId) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("TestRunId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.testRunId = testRunId;
        return _x;
    }

    @Property(name="Title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public TestRun withTitle(String title) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("Title");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.title = title;
        return _x;
    }

    @Property(name="IsAutomated")
    @JsonIgnore
    public Optional<Boolean> getIsAutomated() {
        return Optional.ofNullable(isAutomated);
    }

    public TestRun withIsAutomated(Boolean isAutomated) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("IsAutomated");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.isAutomated = isAutomated;
        return _x;
    }

    @Property(name="TestRunType")
    @JsonIgnore
    public Optional<TestRunType> getTestRunType() {
        return Optional.ofNullable(testRunType);
    }

    public TestRun withTestRunType(TestRunType testRunType) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("TestRunType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.testRunType = testRunType;
        return _x;
    }

    @Property(name="Workflow")
    @JsonIgnore
    public Optional<SourceWorkflow> getWorkflow() {
        return Optional.ofNullable(workflow);
    }

    public TestRun withWorkflow(SourceWorkflow workflow) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("Workflow");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.workflow = workflow;
        return _x;
    }

    @Property(name="PipelineRunSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunSK() {
        return Optional.ofNullable(pipelineRunSK);
    }

    public TestRun withPipelineRunSK(Integer pipelineRunSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.pipelineRunSK = pipelineRunSK;
        return _x;
    }

    @Property(name="PipelineSK")
    @JsonIgnore
    public Optional<Integer> getPipelineSK() {
        return Optional.ofNullable(pipelineSK);
    }

    public TestRun withPipelineSK(Integer pipelineSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("PipelineSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.pipelineSK = pipelineSK;
        return _x;
    }

    @Property(name="BranchSK")
    @JsonIgnore
    public Optional<Integer> getBranchSK() {
        return Optional.ofNullable(branchSK);
    }

    public TestRun withBranchSK(Integer branchSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("BranchSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.branchSK = branchSK;
        return _x;
    }

    @Property(name="CompletedDateSK")
    @JsonIgnore
    public Optional<Integer> getCompletedDateSK() {
        return Optional.ofNullable(completedDateSK);
    }

    public TestRun withCompletedDateSK(Integer completedDateSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("CompletedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.completedDateSK = completedDateSK;
        return _x;
    }

    @Property(name="CompletedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    public TestRun withCompletedDate(OffsetDateTime completedDate) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("CompletedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.completedDate = completedDate;
        return _x;
    }

    @Property(name="StartedDateSK")
    @JsonIgnore
    public Optional<Integer> getStartedDateSK() {
        return Optional.ofNullable(startedDateSK);
    }

    public TestRun withStartedDateSK(Integer startedDateSK) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("StartedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.startedDateSK = startedDateSK;
        return _x;
    }

    @Property(name="StartedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedDate() {
        return Optional.ofNullable(startedDate);
    }

    public TestRun withStartedDate(OffsetDateTime startedDate) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("StartedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.startedDate = startedDate;
        return _x;
    }

    @Property(name="RunDurationSeconds")
    @JsonIgnore
    public Optional<BigDecimal> getRunDurationSeconds() {
        return Optional.ofNullable(runDurationSeconds);
    }

    public TestRun withRunDurationSeconds(BigDecimal runDurationSeconds) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("RunDurationSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.runDurationSeconds = runDurationSeconds;
        return _x;
    }

    @Property(name="ResultDurationSeconds")
    @JsonIgnore
    public Optional<BigDecimal> getResultDurationSeconds() {
        return Optional.ofNullable(resultDurationSeconds);
    }

    public TestRun withResultDurationSeconds(BigDecimal resultDurationSeconds) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultDurationSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultDurationSeconds = resultDurationSeconds;
        return _x;
    }

    @Property(name="ResultCount")
    @JsonIgnore
    public Optional<Integer> getResultCount() {
        return Optional.ofNullable(resultCount);
    }

    public TestRun withResultCount(Integer resultCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultCount = resultCount;
        return _x;
    }

    @Property(name="ResultPassCount")
    @JsonIgnore
    public Optional<Integer> getResultPassCount() {
        return Optional.ofNullable(resultPassCount);
    }

    public TestRun withResultPassCount(Integer resultPassCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultPassCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultPassCount = resultPassCount;
        return _x;
    }

    @Property(name="ResultFailCount")
    @JsonIgnore
    public Optional<Integer> getResultFailCount() {
        return Optional.ofNullable(resultFailCount);
    }

    public TestRun withResultFailCount(Integer resultFailCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultFailCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultFailCount = resultFailCount;
        return _x;
    }

    @Property(name="ResultNoneCount")
    @JsonIgnore
    public Optional<Integer> getResultNoneCount() {
        return Optional.ofNullable(resultNoneCount);
    }

    public TestRun withResultNoneCount(Integer resultNoneCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultNoneCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultNoneCount = resultNoneCount;
        return _x;
    }

    @Property(name="ResultInconclusiveCount")
    @JsonIgnore
    public Optional<Integer> getResultInconclusiveCount() {
        return Optional.ofNullable(resultInconclusiveCount);
    }

    public TestRun withResultInconclusiveCount(Integer resultInconclusiveCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultInconclusiveCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultInconclusiveCount = resultInconclusiveCount;
        return _x;
    }

    @Property(name="ResultTimeoutCount")
    @JsonIgnore
    public Optional<Integer> getResultTimeoutCount() {
        return Optional.ofNullable(resultTimeoutCount);
    }

    public TestRun withResultTimeoutCount(Integer resultTimeoutCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultTimeoutCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultTimeoutCount = resultTimeoutCount;
        return _x;
    }

    @Property(name="ResultAbortedCount")
    @JsonIgnore
    public Optional<Integer> getResultAbortedCount() {
        return Optional.ofNullable(resultAbortedCount);
    }

    public TestRun withResultAbortedCount(Integer resultAbortedCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultAbortedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultAbortedCount = resultAbortedCount;
        return _x;
    }

    @Property(name="ResultBlockedCount")
    @JsonIgnore
    public Optional<Integer> getResultBlockedCount() {
        return Optional.ofNullable(resultBlockedCount);
    }

    public TestRun withResultBlockedCount(Integer resultBlockedCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultBlockedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultBlockedCount = resultBlockedCount;
        return _x;
    }

    @Property(name="ResultNotExecutedCount")
    @JsonIgnore
    public Optional<Integer> getResultNotExecutedCount() {
        return Optional.ofNullable(resultNotExecutedCount);
    }

    public TestRun withResultNotExecutedCount(Integer resultNotExecutedCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultNotExecutedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultNotExecutedCount = resultNotExecutedCount;
        return _x;
    }

    @Property(name="ResultWarningCount")
    @JsonIgnore
    public Optional<Integer> getResultWarningCount() {
        return Optional.ofNullable(resultWarningCount);
    }

    public TestRun withResultWarningCount(Integer resultWarningCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultWarningCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultWarningCount = resultWarningCount;
        return _x;
    }

    @Property(name="ResultErrorCount")
    @JsonIgnore
    public Optional<Integer> getResultErrorCount() {
        return Optional.ofNullable(resultErrorCount);
    }

    public TestRun withResultErrorCount(Integer resultErrorCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultErrorCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultErrorCount = resultErrorCount;
        return _x;
    }

    @Property(name="ResultNotApplicableCount")
    @JsonIgnore
    public Optional<Integer> getResultNotApplicableCount() {
        return Optional.ofNullable(resultNotApplicableCount);
    }

    public TestRun withResultNotApplicableCount(Integer resultNotApplicableCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultNotApplicableCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultNotApplicableCount = resultNotApplicableCount;
        return _x;
    }

    @Property(name="ResultNotImpactedCount")
    @JsonIgnore
    public Optional<Integer> getResultNotImpactedCount() {
        return Optional.ofNullable(resultNotImpactedCount);
    }

    public TestRun withResultNotImpactedCount(Integer resultNotImpactedCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultNotImpactedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultNotImpactedCount = resultNotImpactedCount;
        return _x;
    }

    @Property(name="HasDetail")
    @JsonIgnore
    public Optional<Boolean> getHasDetail() {
        return Optional.ofNullable(hasDetail);
    }

    public TestRun withHasDetail(Boolean hasDetail) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("HasDetail");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.hasDetail = hasDetail;
        return _x;
    }

    @Property(name="ReleaseId")
    @JsonIgnore
    public Optional<Integer> getReleaseId() {
        return Optional.ofNullable(releaseId);
    }

    public TestRun withReleaseId(Integer releaseId) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ReleaseId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.releaseId = releaseId;
        return _x;
    }

    @Property(name="ReleaseEnvironmentId")
    @JsonIgnore
    public Optional<Integer> getReleaseEnvironmentId() {
        return Optional.ofNullable(releaseEnvironmentId);
    }

    public TestRun withReleaseEnvironmentId(Integer releaseEnvironmentId) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ReleaseEnvironmentId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.releaseEnvironmentId = releaseEnvironmentId;
        return _x;
    }

    @Property(name="ReleasePipelineId")
    @JsonIgnore
    public Optional<Integer> getReleasePipelineId() {
        return Optional.ofNullable(releasePipelineId);
    }

    public TestRun withReleasePipelineId(Integer releasePipelineId) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ReleasePipelineId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.releasePipelineId = releasePipelineId;
        return _x;
    }

    @Property(name="ReleaseStageId")
    @JsonIgnore
    public Optional<Integer> getReleaseStageId() {
        return Optional.ofNullable(releaseStageId);
    }

    public TestRun withReleaseStageId(Integer releaseStageId) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ReleaseStageId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.releaseStageId = releaseStageId;
        return _x;
    }

    @Property(name="ResultFlakyCount")
    @JsonIgnore
    public Optional<Integer> getResultFlakyCount() {
        return Optional.ofNullable(resultFlakyCount);
    }

    public TestRun withResultFlakyCount(Integer resultFlakyCount) {
        TestRun _x = _copy();
        _x.changedFields = changedFields.add("ResultFlakyCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestRun");
        _x.resultFlakyCount = resultFlakyCount;
        return _x;
    }

    public TestRun withUnmappedField(String name, String value) {
        TestRun _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="PipelineRun")
    @JsonIgnore
    public PipelineRunRequest getPipelineRun() {
        return new PipelineRunRequest(contextPath.addSegment("PipelineRun"), RequestHelper.getValue(unmappedFields, "PipelineRun"));
    }

    @NavigationProperty(name="Pipeline")
    @JsonIgnore
    public PipelineRequest getPipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), RequestHelper.getValue(unmappedFields, "Pipeline"));
    }

    @NavigationProperty(name="Branch")
    @JsonIgnore
    public BranchRequest getBranch() {
        return new BranchRequest(contextPath.addSegment("Branch"), RequestHelper.getValue(unmappedFields, "Branch"));
    }

    @NavigationProperty(name="CompletedOn")
    @JsonIgnore
    public CalendarDateRequest getCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("CompletedOn"), RequestHelper.getValue(unmappedFields, "CompletedOn"));
    }

    @NavigationProperty(name="StartedOn")
    @JsonIgnore
    public CalendarDateRequest getStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("StartedOn"), RequestHelper.getValue(unmappedFields, "StartedOn"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestRun patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TestRun _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestRun put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TestRun _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TestRun _copy() {
        TestRun _x = new TestRun();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.projectSK = projectSK;
        _x.testRunSK = testRunSK;
        _x.testRunId = testRunId;
        _x.title = title;
        _x.isAutomated = isAutomated;
        _x.testRunType = testRunType;
        _x.workflow = workflow;
        _x.pipelineRunSK = pipelineRunSK;
        _x.pipelineSK = pipelineSK;
        _x.branchSK = branchSK;
        _x.completedDateSK = completedDateSK;
        _x.completedDate = completedDate;
        _x.startedDateSK = startedDateSK;
        _x.startedDate = startedDate;
        _x.runDurationSeconds = runDurationSeconds;
        _x.resultDurationSeconds = resultDurationSeconds;
        _x.resultCount = resultCount;
        _x.resultPassCount = resultPassCount;
        _x.resultFailCount = resultFailCount;
        _x.resultNoneCount = resultNoneCount;
        _x.resultInconclusiveCount = resultInconclusiveCount;
        _x.resultTimeoutCount = resultTimeoutCount;
        _x.resultAbortedCount = resultAbortedCount;
        _x.resultBlockedCount = resultBlockedCount;
        _x.resultNotExecutedCount = resultNotExecutedCount;
        _x.resultWarningCount = resultWarningCount;
        _x.resultErrorCount = resultErrorCount;
        _x.resultNotApplicableCount = resultNotApplicableCount;
        _x.resultNotImpactedCount = resultNotImpactedCount;
        _x.hasDetail = hasDetail;
        _x.releaseId = releaseId;
        _x.releaseEnvironmentId = releaseEnvironmentId;
        _x.releasePipelineId = releasePipelineId;
        _x.releaseStageId = releaseStageId;
        _x.resultFlakyCount = resultFlakyCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TestRun[");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestRunSK=");
        b.append(this.testRunSK);
        b.append(", ");
        b.append("TestRunId=");
        b.append(this.testRunId);
        b.append(", ");
        b.append("Title=");
        b.append(this.title);
        b.append(", ");
        b.append("IsAutomated=");
        b.append(this.isAutomated);
        b.append(", ");
        b.append("TestRunType=");
        b.append(this.testRunType);
        b.append(", ");
        b.append("Workflow=");
        b.append(this.workflow);
        b.append(", ");
        b.append("PipelineRunSK=");
        b.append(this.pipelineRunSK);
        b.append(", ");
        b.append("PipelineSK=");
        b.append(this.pipelineSK);
        b.append(", ");
        b.append("BranchSK=");
        b.append(this.branchSK);
        b.append(", ");
        b.append("CompletedDateSK=");
        b.append(this.completedDateSK);
        b.append(", ");
        b.append("CompletedDate=");
        b.append(this.completedDate);
        b.append(", ");
        b.append("StartedDateSK=");
        b.append(this.startedDateSK);
        b.append(", ");
        b.append("StartedDate=");
        b.append(this.startedDate);
        b.append(", ");
        b.append("RunDurationSeconds=");
        b.append(this.runDurationSeconds);
        b.append(", ");
        b.append("ResultDurationSeconds=");
        b.append(this.resultDurationSeconds);
        b.append(", ");
        b.append("ResultCount=");
        b.append(this.resultCount);
        b.append(", ");
        b.append("ResultPassCount=");
        b.append(this.resultPassCount);
        b.append(", ");
        b.append("ResultFailCount=");
        b.append(this.resultFailCount);
        b.append(", ");
        b.append("ResultNoneCount=");
        b.append(this.resultNoneCount);
        b.append(", ");
        b.append("ResultInconclusiveCount=");
        b.append(this.resultInconclusiveCount);
        b.append(", ");
        b.append("ResultTimeoutCount=");
        b.append(this.resultTimeoutCount);
        b.append(", ");
        b.append("ResultAbortedCount=");
        b.append(this.resultAbortedCount);
        b.append(", ");
        b.append("ResultBlockedCount=");
        b.append(this.resultBlockedCount);
        b.append(", ");
        b.append("ResultNotExecutedCount=");
        b.append(this.resultNotExecutedCount);
        b.append(", ");
        b.append("ResultWarningCount=");
        b.append(this.resultWarningCount);
        b.append(", ");
        b.append("ResultErrorCount=");
        b.append(this.resultErrorCount);
        b.append(", ");
        b.append("ResultNotApplicableCount=");
        b.append(this.resultNotApplicableCount);
        b.append(", ");
        b.append("ResultNotImpactedCount=");
        b.append(this.resultNotImpactedCount);
        b.append(", ");
        b.append("HasDetail=");
        b.append(this.hasDetail);
        b.append(", ");
        b.append("ReleaseId=");
        b.append(this.releaseId);
        b.append(", ");
        b.append("ReleaseEnvironmentId=");
        b.append(this.releaseEnvironmentId);
        b.append(", ");
        b.append("ReleasePipelineId=");
        b.append(this.releasePipelineId);
        b.append(", ");
        b.append("ReleaseStageId=");
        b.append(this.releaseStageId);
        b.append(", ");
        b.append("ResultFlakyCount=");
        b.append(this.resultFlakyCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
