package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.CalendarDateRequest;
import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.entity.request.TestConfigurationRequest;
import microsoft.vs.analytics.v3.model.entity.request.TestSuiteRequest;
import microsoft.vs.analytics.v3.model.entity.request.UserRequest;
import microsoft.vs.analytics.v3.model.entity.request.WorkItemRequest;
import microsoft.vs.analytics.v3.model.enums.Period;
import microsoft.vs.analytics.v3.model.enums.TestOutcome;

@JsonPropertyOrder({
    "@odata.type", 
    "ResultOutcome", 
    "DateSK", 
    "IsLastDayOfPeriod", 
    "TestPointSK", 
    "AnalyticsUpdatedDate", 
    "ProjectSK", 
    "TestSuiteSK", 
    "TestPlanId", 
    "TestSuiteId", 
    "TestPointId", 
    "TestConfigurationSK", 
    "TestConfigurationId", 
    "TestCaseId", 
    "TesterUserSK", 
    "AssignedToUserSK", 
    "Priority", 
    "AutomationStatus"})
@JsonInclude(Include.NON_NULL)
public class TestPointHistorySnapshot implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResultOutcome")
    protected TestOutcome resultOutcome;

    @JsonProperty("DateSK")
    protected Integer dateSK;

    @JsonProperty("IsLastDayOfPeriod")
    protected Period isLastDayOfPeriod;

    @JsonProperty("TestPointSK")
    protected Integer testPointSK;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TestSuiteSK")
    protected Integer testSuiteSK;

    @JsonProperty("TestPlanId")
    protected Integer testPlanId;

    @JsonProperty("TestSuiteId")
    protected Integer testSuiteId;

    @JsonProperty("TestPointId")
    protected Integer testPointId;

    @JsonProperty("TestConfigurationSK")
    protected Integer testConfigurationSK;

    @JsonProperty("TestConfigurationId")
    protected Integer testConfigurationId;

    @JsonProperty("TestCaseId")
    protected Integer testCaseId;

    @JsonProperty("TesterUserSK")
    protected String testerUserSK;

    @JsonProperty("AssignedToUserSK")
    protected String assignedToUserSK;

    @JsonProperty("Priority")
    protected Integer priority;

    @JsonProperty("AutomationStatus")
    protected String automationStatus;

    protected TestPointHistorySnapshot() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TestOutcome resultOutcome;
        private Integer dateSK;
        private Period isLastDayOfPeriod;
        private Integer testPointSK;
        private OffsetDateTime analyticsUpdatedDate;
        private String projectSK;
        private Integer testSuiteSK;
        private Integer testPlanId;
        private Integer testSuiteId;
        private Integer testPointId;
        private Integer testConfigurationSK;
        private Integer testConfigurationId;
        private Integer testCaseId;
        private String testerUserSK;
        private String assignedToUserSK;
        private Integer priority;
        private String automationStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resultOutcome(TestOutcome resultOutcome) {
            this.resultOutcome = resultOutcome;
            this.changedFields = changedFields.add("ResultOutcome");
            return this;
        }

        public Builder dateSK(Integer dateSK) {
            this.dateSK = dateSK;
            this.changedFields = changedFields.add("DateSK");
            return this;
        }

        public Builder isLastDayOfPeriod(Period isLastDayOfPeriod) {
            this.isLastDayOfPeriod = isLastDayOfPeriod;
            this.changedFields = changedFields.add("IsLastDayOfPeriod");
            return this;
        }

        public Builder testPointSK(Integer testPointSK) {
            this.testPointSK = testPointSK;
            this.changedFields = changedFields.add("TestPointSK");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder testSuiteSK(Integer testSuiteSK) {
            this.testSuiteSK = testSuiteSK;
            this.changedFields = changedFields.add("TestSuiteSK");
            return this;
        }

        public Builder testPlanId(Integer testPlanId) {
            this.testPlanId = testPlanId;
            this.changedFields = changedFields.add("TestPlanId");
            return this;
        }

        public Builder testSuiteId(Integer testSuiteId) {
            this.testSuiteId = testSuiteId;
            this.changedFields = changedFields.add("TestSuiteId");
            return this;
        }

        public Builder testPointId(Integer testPointId) {
            this.testPointId = testPointId;
            this.changedFields = changedFields.add("TestPointId");
            return this;
        }

        public Builder testConfigurationSK(Integer testConfigurationSK) {
            this.testConfigurationSK = testConfigurationSK;
            this.changedFields = changedFields.add("TestConfigurationSK");
            return this;
        }

        public Builder testConfigurationId(Integer testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            this.changedFields = changedFields.add("TestConfigurationId");
            return this;
        }

        public Builder testCaseId(Integer testCaseId) {
            this.testCaseId = testCaseId;
            this.changedFields = changedFields.add("TestCaseId");
            return this;
        }

        public Builder testerUserSK(String testerUserSK) {
            this.testerUserSK = testerUserSK;
            this.changedFields = changedFields.add("TesterUserSK");
            return this;
        }

        public Builder assignedToUserSK(String assignedToUserSK) {
            this.assignedToUserSK = assignedToUserSK;
            this.changedFields = changedFields.add("AssignedToUserSK");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("Priority");
            return this;
        }

        public Builder automationStatus(String automationStatus) {
            this.automationStatus = automationStatus;
            this.changedFields = changedFields.add("AutomationStatus");
            return this;
        }

        public TestPointHistorySnapshot build() {
            TestPointHistorySnapshot _x = new TestPointHistorySnapshot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot";
            _x.resultOutcome = resultOutcome;
            _x.dateSK = dateSK;
            _x.isLastDayOfPeriod = isLastDayOfPeriod;
            _x.testPointSK = testPointSK;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            _x.projectSK = projectSK;
            _x.testSuiteSK = testSuiteSK;
            _x.testPlanId = testPlanId;
            _x.testSuiteId = testSuiteId;
            _x.testPointId = testPointId;
            _x.testConfigurationSK = testConfigurationSK;
            _x.testConfigurationId = testConfigurationId;
            _x.testCaseId = testCaseId;
            _x.testerUserSK = testerUserSK;
            _x.assignedToUserSK = assignedToUserSK;
            _x.priority = priority;
            _x.automationStatus = automationStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && dateSK != null && testPointSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue("DateSK", dateSK), new NameValue("TestPointSK", testPointSK));
        }
    }

    @Property(name="ResultOutcome")
    @JsonIgnore
    public Optional<TestOutcome> getResultOutcome() {
        return Optional.ofNullable(resultOutcome);
    }

    public TestPointHistorySnapshot withResultOutcome(TestOutcome resultOutcome) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("ResultOutcome");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.resultOutcome = resultOutcome;
        return _x;
    }

    @Property(name="DateSK")
    @JsonIgnore
    public Optional<Integer> getDateSK() {
        return Optional.ofNullable(dateSK);
    }

    public TestPointHistorySnapshot withDateSK(Integer dateSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("DateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.dateSK = dateSK;
        return _x;
    }

    @Property(name="IsLastDayOfPeriod")
    @JsonIgnore
    public Optional<Period> getIsLastDayOfPeriod() {
        return Optional.ofNullable(isLastDayOfPeriod);
    }

    public TestPointHistorySnapshot withIsLastDayOfPeriod(Period isLastDayOfPeriod) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("IsLastDayOfPeriod");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.isLastDayOfPeriod = isLastDayOfPeriod;
        return _x;
    }

    @Property(name="TestPointSK")
    @JsonIgnore
    public Optional<Integer> getTestPointSK() {
        return Optional.ofNullable(testPointSK);
    }

    public TestPointHistorySnapshot withTestPointSK(Integer testPointSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestPointSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testPointSK = testPointSK;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public TestPointHistorySnapshot withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public TestPointHistorySnapshot withProjectSK(String projectSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TestSuiteSK")
    @JsonIgnore
    public Optional<Integer> getTestSuiteSK() {
        return Optional.ofNullable(testSuiteSK);
    }

    public TestPointHistorySnapshot withTestSuiteSK(Integer testSuiteSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestSuiteSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testSuiteSK = testSuiteSK;
        return _x;
    }

    @Property(name="TestPlanId")
    @JsonIgnore
    public Optional<Integer> getTestPlanId() {
        return Optional.ofNullable(testPlanId);
    }

    public TestPointHistorySnapshot withTestPlanId(Integer testPlanId) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestPlanId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testPlanId = testPlanId;
        return _x;
    }

    @Property(name="TestSuiteId")
    @JsonIgnore
    public Optional<Integer> getTestSuiteId() {
        return Optional.ofNullable(testSuiteId);
    }

    public TestPointHistorySnapshot withTestSuiteId(Integer testSuiteId) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestSuiteId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testSuiteId = testSuiteId;
        return _x;
    }

    @Property(name="TestPointId")
    @JsonIgnore
    public Optional<Integer> getTestPointId() {
        return Optional.ofNullable(testPointId);
    }

    public TestPointHistorySnapshot withTestPointId(Integer testPointId) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestPointId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testPointId = testPointId;
        return _x;
    }

    @Property(name="TestConfigurationSK")
    @JsonIgnore
    public Optional<Integer> getTestConfigurationSK() {
        return Optional.ofNullable(testConfigurationSK);
    }

    public TestPointHistorySnapshot withTestConfigurationSK(Integer testConfigurationSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestConfigurationSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testConfigurationSK = testConfigurationSK;
        return _x;
    }

    @Property(name="TestConfigurationId")
    @JsonIgnore
    public Optional<Integer> getTestConfigurationId() {
        return Optional.ofNullable(testConfigurationId);
    }

    public TestPointHistorySnapshot withTestConfigurationId(Integer testConfigurationId) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestConfigurationId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testConfigurationId = testConfigurationId;
        return _x;
    }

    @Property(name="TestCaseId")
    @JsonIgnore
    public Optional<Integer> getTestCaseId() {
        return Optional.ofNullable(testCaseId);
    }

    public TestPointHistorySnapshot withTestCaseId(Integer testCaseId) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TestCaseId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testCaseId = testCaseId;
        return _x;
    }

    @Property(name="TesterUserSK")
    @JsonIgnore
    public Optional<String> getTesterUserSK() {
        return Optional.ofNullable(testerUserSK);
    }

    public TestPointHistorySnapshot withTesterUserSK(String testerUserSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("TesterUserSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.testerUserSK = testerUserSK;
        return _x;
    }

    @Property(name="AssignedToUserSK")
    @JsonIgnore
    public Optional<String> getAssignedToUserSK() {
        return Optional.ofNullable(assignedToUserSK);
    }

    public TestPointHistorySnapshot withAssignedToUserSK(String assignedToUserSK) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("AssignedToUserSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.assignedToUserSK = assignedToUserSK;
        return _x;
    }

    @Property(name="Priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public TestPointHistorySnapshot withPriority(Integer priority) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("Priority");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.priority = priority;
        return _x;
    }

    @Property(name="AutomationStatus")
    @JsonIgnore
    public Optional<String> getAutomationStatus() {
        return Optional.ofNullable(automationStatus);
    }

    public TestPointHistorySnapshot withAutomationStatus(String automationStatus) {
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = changedFields.add("AutomationStatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.TestPointHistorySnapshot");
        _x.automationStatus = automationStatus;
        return _x;
    }

    public TestPointHistorySnapshot withUnmappedField(String name, String value) {
        TestPointHistorySnapshot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Date")
    @JsonIgnore
    public CalendarDateRequest getDate() {
        return new CalendarDateRequest(contextPath.addSegment("Date"), RequestHelper.getValue(unmappedFields, "Date"));
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="TestSuite")
    @JsonIgnore
    public TestSuiteRequest getTestSuite() {
        return new TestSuiteRequest(contextPath.addSegment("TestSuite"), RequestHelper.getValue(unmappedFields, "TestSuite"));
    }

    @NavigationProperty(name="TestConfiguration")
    @JsonIgnore
    public TestConfigurationRequest getTestConfiguration() {
        return new TestConfigurationRequest(contextPath.addSegment("TestConfiguration"), RequestHelper.getValue(unmappedFields, "TestConfiguration"));
    }

    @NavigationProperty(name="TestCase")
    @JsonIgnore
    public WorkItemRequest getTestCase() {
        return new WorkItemRequest(contextPath.addSegment("TestCase"), RequestHelper.getValue(unmappedFields, "TestCase"));
    }

    @NavigationProperty(name="Tester")
    @JsonIgnore
    public UserRequest getTester() {
        return new UserRequest(contextPath.addSegment("Tester"), RequestHelper.getValue(unmappedFields, "Tester"));
    }

    @NavigationProperty(name="AssignedTo")
    @JsonIgnore
    public UserRequest getAssignedTo() {
        return new UserRequest(contextPath.addSegment("AssignedTo"), RequestHelper.getValue(unmappedFields, "AssignedTo"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestPointHistorySnapshot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TestPointHistorySnapshot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TestPointHistorySnapshot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TestPointHistorySnapshot _copy() {
        TestPointHistorySnapshot _x = new TestPointHistorySnapshot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resultOutcome = resultOutcome;
        _x.dateSK = dateSK;
        _x.isLastDayOfPeriod = isLastDayOfPeriod;
        _x.testPointSK = testPointSK;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        _x.projectSK = projectSK;
        _x.testSuiteSK = testSuiteSK;
        _x.testPlanId = testPlanId;
        _x.testSuiteId = testSuiteId;
        _x.testPointId = testPointId;
        _x.testConfigurationSK = testConfigurationSK;
        _x.testConfigurationId = testConfigurationId;
        _x.testCaseId = testCaseId;
        _x.testerUserSK = testerUserSK;
        _x.assignedToUserSK = assignedToUserSK;
        _x.priority = priority;
        _x.automationStatus = automationStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TestPointHistorySnapshot[");
        b.append("ResultOutcome=");
        b.append(this.resultOutcome);
        b.append(", ");
        b.append("DateSK=");
        b.append(this.dateSK);
        b.append(", ");
        b.append("IsLastDayOfPeriod=");
        b.append(this.isLastDayOfPeriod);
        b.append(", ");
        b.append("TestPointSK=");
        b.append(this.testPointSK);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TestSuiteSK=");
        b.append(this.testSuiteSK);
        b.append(", ");
        b.append("TestPlanId=");
        b.append(this.testPlanId);
        b.append(", ");
        b.append("TestSuiteId=");
        b.append(this.testSuiteId);
        b.append(", ");
        b.append("TestPointId=");
        b.append(this.testPointId);
        b.append(", ");
        b.append("TestConfigurationSK=");
        b.append(this.testConfigurationSK);
        b.append(", ");
        b.append("TestConfigurationId=");
        b.append(this.testConfigurationId);
        b.append(", ");
        b.append("TestCaseId=");
        b.append(this.testCaseId);
        b.append(", ");
        b.append("TesterUserSK=");
        b.append(this.testerUserSK);
        b.append(", ");
        b.append("AssignedToUserSK=");
        b.append(this.assignedToUserSK);
        b.append(", ");
        b.append("Priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("AutomationStatus=");
        b.append(this.automationStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
