package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProcessSK", 
    "ProjectSK", 
    "BacklogCategoryReferenceName", 
    "BacklogName", 
    "BacklogType", 
    "BacklogLevel", 
    "WorkItemType", 
    "HasBacklog", 
    "IsHiddenType", 
    "IsBugType", 
    "TeamSK", 
    "AnalyticsUpdatedDate"})
@JsonInclude(Include.NON_NULL)
public class Process implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Process";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProcessSK")
    protected Integer processSK;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("BacklogCategoryReferenceName")
    protected String backlogCategoryReferenceName;

    @JsonProperty("BacklogName")
    protected String backlogName;

    @JsonProperty("BacklogType")
    protected String backlogType;

    @JsonProperty("BacklogLevel")
    protected Integer backlogLevel;

    @JsonProperty("WorkItemType")
    protected String workItemType;

    @JsonProperty("HasBacklog")
    protected Boolean hasBacklog;

    @JsonProperty("IsHiddenType")
    protected Boolean isHiddenType;

    @JsonProperty("IsBugType")
    protected Boolean isBugType;

    @JsonProperty("TeamSK")
    protected String teamSK;

    @JsonProperty("AnalyticsUpdatedDate")
    protected OffsetDateTime analyticsUpdatedDate;

    protected Process() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer processSK;
        private String projectSK;
        private String backlogCategoryReferenceName;
        private String backlogName;
        private String backlogType;
        private Integer backlogLevel;
        private String workItemType;
        private Boolean hasBacklog;
        private Boolean isHiddenType;
        private Boolean isBugType;
        private String teamSK;
        private OffsetDateTime analyticsUpdatedDate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder processSK(Integer processSK) {
            this.processSK = processSK;
            this.changedFields = changedFields.add("ProcessSK");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder backlogCategoryReferenceName(String backlogCategoryReferenceName) {
            this.backlogCategoryReferenceName = backlogCategoryReferenceName;
            this.changedFields = changedFields.add("BacklogCategoryReferenceName");
            return this;
        }

        public Builder backlogName(String backlogName) {
            this.backlogName = backlogName;
            this.changedFields = changedFields.add("BacklogName");
            return this;
        }

        public Builder backlogType(String backlogType) {
            this.backlogType = backlogType;
            this.changedFields = changedFields.add("BacklogType");
            return this;
        }

        public Builder backlogLevel(Integer backlogLevel) {
            this.backlogLevel = backlogLevel;
            this.changedFields = changedFields.add("BacklogLevel");
            return this;
        }

        public Builder workItemType(String workItemType) {
            this.workItemType = workItemType;
            this.changedFields = changedFields.add("WorkItemType");
            return this;
        }

        public Builder hasBacklog(Boolean hasBacklog) {
            this.hasBacklog = hasBacklog;
            this.changedFields = changedFields.add("HasBacklog");
            return this;
        }

        public Builder isHiddenType(Boolean isHiddenType) {
            this.isHiddenType = isHiddenType;
            this.changedFields = changedFields.add("IsHiddenType");
            return this;
        }

        public Builder isBugType(Boolean isBugType) {
            this.isBugType = isBugType;
            this.changedFields = changedFields.add("IsBugType");
            return this;
        }

        public Builder teamSK(String teamSK) {
            this.teamSK = teamSK;
            this.changedFields = changedFields.add("TeamSK");
            return this;
        }

        public Builder analyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
            this.analyticsUpdatedDate = analyticsUpdatedDate;
            this.changedFields = changedFields.add("AnalyticsUpdatedDate");
            return this;
        }

        public Process build() {
            Process _x = new Process();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Process";
            _x.processSK = processSK;
            _x.projectSK = projectSK;
            _x.backlogCategoryReferenceName = backlogCategoryReferenceName;
            _x.backlogName = backlogName;
            _x.backlogType = backlogType;
            _x.backlogLevel = backlogLevel;
            _x.workItemType = workItemType;
            _x.hasBacklog = hasBacklog;
            _x.isHiddenType = isHiddenType;
            _x.isBugType = isBugType;
            _x.teamSK = teamSK;
            _x.analyticsUpdatedDate = analyticsUpdatedDate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && processSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(processSK.toString()));
        }
    }

    @Property(name="ProcessSK")
    @JsonIgnore
    public Optional<Integer> getProcessSK() {
        return Optional.ofNullable(processSK);
    }

    public Process withProcessSK(Integer processSK) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("ProcessSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.processSK = processSK;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Process withProjectSK(String projectSK) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="BacklogCategoryReferenceName")
    @JsonIgnore
    public Optional<String> getBacklogCategoryReferenceName() {
        return Optional.ofNullable(backlogCategoryReferenceName);
    }

    public Process withBacklogCategoryReferenceName(String backlogCategoryReferenceName) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("BacklogCategoryReferenceName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.backlogCategoryReferenceName = backlogCategoryReferenceName;
        return _x;
    }

    @Property(name="BacklogName")
    @JsonIgnore
    public Optional<String> getBacklogName() {
        return Optional.ofNullable(backlogName);
    }

    public Process withBacklogName(String backlogName) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("BacklogName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.backlogName = backlogName;
        return _x;
    }

    @Property(name="BacklogType")
    @JsonIgnore
    public Optional<String> getBacklogType() {
        return Optional.ofNullable(backlogType);
    }

    public Process withBacklogType(String backlogType) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("BacklogType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.backlogType = backlogType;
        return _x;
    }

    @Property(name="BacklogLevel")
    @JsonIgnore
    public Optional<Integer> getBacklogLevel() {
        return Optional.ofNullable(backlogLevel);
    }

    public Process withBacklogLevel(Integer backlogLevel) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("BacklogLevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.backlogLevel = backlogLevel;
        return _x;
    }

    @Property(name="WorkItemType")
    @JsonIgnore
    public Optional<String> getWorkItemType() {
        return Optional.ofNullable(workItemType);
    }

    public Process withWorkItemType(String workItemType) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("WorkItemType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.workItemType = workItemType;
        return _x;
    }

    @Property(name="HasBacklog")
    @JsonIgnore
    public Optional<Boolean> getHasBacklog() {
        return Optional.ofNullable(hasBacklog);
    }

    public Process withHasBacklog(Boolean hasBacklog) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("HasBacklog");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.hasBacklog = hasBacklog;
        return _x;
    }

    @Property(name="IsHiddenType")
    @JsonIgnore
    public Optional<Boolean> getIsHiddenType() {
        return Optional.ofNullable(isHiddenType);
    }

    public Process withIsHiddenType(Boolean isHiddenType) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("IsHiddenType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.isHiddenType = isHiddenType;
        return _x;
    }

    @Property(name="IsBugType")
    @JsonIgnore
    public Optional<Boolean> getIsBugType() {
        return Optional.ofNullable(isBugType);
    }

    public Process withIsBugType(Boolean isBugType) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("IsBugType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.isBugType = isBugType;
        return _x;
    }

    @Property(name="TeamSK")
    @JsonIgnore
    public Optional<String> getTeamSK() {
        return Optional.ofNullable(teamSK);
    }

    public Process withTeamSK(String teamSK) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("TeamSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.teamSK = teamSK;
        return _x;
    }

    @Property(name="AnalyticsUpdatedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getAnalyticsUpdatedDate() {
        return Optional.ofNullable(analyticsUpdatedDate);
    }

    public Process withAnalyticsUpdatedDate(OffsetDateTime analyticsUpdatedDate) {
        Process _x = _copy();
        _x.changedFields = changedFields.add("AnalyticsUpdatedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Process");
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    public Process withUnmappedField(String name, String value) {
        Process _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="Team")
    @JsonIgnore
    public TeamRequest getTeam() {
        return new TeamRequest(contextPath.addSegment("Team"), RequestHelper.getValue(unmappedFields, "Team"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Process patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Process _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Process put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Process _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Process _copy() {
        Process _x = new Process();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.processSK = processSK;
        _x.projectSK = projectSK;
        _x.backlogCategoryReferenceName = backlogCategoryReferenceName;
        _x.backlogName = backlogName;
        _x.backlogType = backlogType;
        _x.backlogLevel = backlogLevel;
        _x.workItemType = workItemType;
        _x.hasBacklog = hasBacklog;
        _x.isHiddenType = isHiddenType;
        _x.isBugType = isBugType;
        _x.teamSK = teamSK;
        _x.analyticsUpdatedDate = analyticsUpdatedDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Process[");
        b.append("ProcessSK=");
        b.append(this.processSK);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("BacklogCategoryReferenceName=");
        b.append(this.backlogCategoryReferenceName);
        b.append(", ");
        b.append("BacklogName=");
        b.append(this.backlogName);
        b.append(", ");
        b.append("BacklogType=");
        b.append(this.backlogType);
        b.append(", ");
        b.append("BacklogLevel=");
        b.append(this.backlogLevel);
        b.append(", ");
        b.append("WorkItemType=");
        b.append(this.workItemType);
        b.append(", ");
        b.append("HasBacklog=");
        b.append(this.hasBacklog);
        b.append(", ");
        b.append("IsHiddenType=");
        b.append(this.isHiddenType);
        b.append(", ");
        b.append("IsBugType=");
        b.append(this.isBugType);
        b.append(", ");
        b.append("TeamSK=");
        b.append(this.teamSK);
        b.append(", ");
        b.append("AnalyticsUpdatedDate=");
        b.append(this.analyticsUpdatedDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
