package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "PipelineTaskSK", 
    "ProjectSK", 
    "TaskDefinitionId", 
    "TaskDefinitionName", 
    "TaskDefinitionVersion"})
@JsonInclude(Include.NON_NULL)
public class PipelineTask implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PipelineTaskSK")
    protected Integer pipelineTaskSK;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TaskDefinitionId")
    protected String taskDefinitionId;

    @JsonProperty("TaskDefinitionName")
    protected String taskDefinitionName;

    @JsonProperty("TaskDefinitionVersion")
    protected String taskDefinitionVersion;

    protected PipelineTask() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer pipelineTaskSK;
        private String projectSK;
        private String taskDefinitionId;
        private String taskDefinitionName;
        private String taskDefinitionVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder pipelineTaskSK(Integer pipelineTaskSK) {
            this.pipelineTaskSK = pipelineTaskSK;
            this.changedFields = changedFields.add("PipelineTaskSK");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder taskDefinitionId(String taskDefinitionId) {
            this.taskDefinitionId = taskDefinitionId;
            this.changedFields = changedFields.add("TaskDefinitionId");
            return this;
        }

        public Builder taskDefinitionName(String taskDefinitionName) {
            this.taskDefinitionName = taskDefinitionName;
            this.changedFields = changedFields.add("TaskDefinitionName");
            return this;
        }

        public Builder taskDefinitionVersion(String taskDefinitionVersion) {
            this.taskDefinitionVersion = taskDefinitionVersion;
            this.changedFields = changedFields.add("TaskDefinitionVersion");
            return this;
        }

        public PipelineTask build() {
            PipelineTask _x = new PipelineTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask";
            _x.pipelineTaskSK = pipelineTaskSK;
            _x.projectSK = projectSK;
            _x.taskDefinitionId = taskDefinitionId;
            _x.taskDefinitionName = taskDefinitionName;
            _x.taskDefinitionVersion = taskDefinitionVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && pipelineTaskSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(pipelineTaskSK.toString()));
        }
    }

    @Property(name="PipelineTaskSK")
    @JsonIgnore
    public Optional<Integer> getPipelineTaskSK() {
        return Optional.ofNullable(pipelineTaskSK);
    }

    public PipelineTask withPipelineTaskSK(Integer pipelineTaskSK) {
        PipelineTask _x = _copy();
        _x.changedFields = changedFields.add("PipelineTaskSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask");
        _x.pipelineTaskSK = pipelineTaskSK;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public PipelineTask withProjectSK(String projectSK) {
        PipelineTask _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TaskDefinitionId")
    @JsonIgnore
    public Optional<String> getTaskDefinitionId() {
        return Optional.ofNullable(taskDefinitionId);
    }

    public PipelineTask withTaskDefinitionId(String taskDefinitionId) {
        PipelineTask _x = _copy();
        _x.changedFields = changedFields.add("TaskDefinitionId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask");
        _x.taskDefinitionId = taskDefinitionId;
        return _x;
    }

    @Property(name="TaskDefinitionName")
    @JsonIgnore
    public Optional<String> getTaskDefinitionName() {
        return Optional.ofNullable(taskDefinitionName);
    }

    public PipelineTask withTaskDefinitionName(String taskDefinitionName) {
        PipelineTask _x = _copy();
        _x.changedFields = changedFields.add("TaskDefinitionName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask");
        _x.taskDefinitionName = taskDefinitionName;
        return _x;
    }

    @Property(name="TaskDefinitionVersion")
    @JsonIgnore
    public Optional<String> getTaskDefinitionVersion() {
        return Optional.ofNullable(taskDefinitionVersion);
    }

    public PipelineTask withTaskDefinitionVersion(String taskDefinitionVersion) {
        PipelineTask _x = _copy();
        _x.changedFields = changedFields.add("TaskDefinitionVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineTask");
        _x.taskDefinitionVersion = taskDefinitionVersion;
        return _x;
    }

    public PipelineTask withUnmappedField(String name, String value) {
        PipelineTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PipelineTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PipelineTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PipelineTask _copy() {
        PipelineTask _x = new PipelineTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.pipelineTaskSK = pipelineTaskSK;
        _x.projectSK = projectSK;
        _x.taskDefinitionId = taskDefinitionId;
        _x.taskDefinitionName = taskDefinitionName;
        _x.taskDefinitionVersion = taskDefinitionVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PipelineTask[");
        b.append("PipelineTaskSK=");
        b.append(this.pipelineTaskSK);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TaskDefinitionId=");
        b.append(this.taskDefinitionId);
        b.append(", ");
        b.append("TaskDefinitionName=");
        b.append(this.taskDefinitionName);
        b.append(", ");
        b.append("TaskDefinitionVersion=");
        b.append(this.taskDefinitionVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
