package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.BranchRequest;
import microsoft.vs.analytics.v3.model.entity.request.CalendarDateRequest;
import microsoft.vs.analytics.v3.model.entity.request.PipelineJobRequest;
import microsoft.vs.analytics.v3.model.entity.request.PipelineRequest;
import microsoft.vs.analytics.v3.model.entity.request.PipelineTaskRequest;
import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.enums.PipelineActivityType;
import microsoft.vs.analytics.v3.model.enums.PipelineRunOutcome;
import microsoft.vs.analytics.v3.model.enums.PipelineRunTaskOutcome;

@JsonPropertyOrder({
    "@odata.type", 
    "PipelineRunActivityResultSK", 
    "ProjectSK", 
    "PipelineRunId", 
    "PipelineSK", 
    "PipelineTaskSK", 
    "PipelineJobSK", 
    "BranchSK", 
    "PipelineRunQueuedDateSK", 
    "PipelineRunStartedDateSK", 
    "PipelineRunCompletedDateSK", 
    "ActivityStartedDateSK", 
    "ActivityStartedDate", 
    "ActivityCompletedDateSK", 
    "ActivityCompletedDate", 
    "TaskDisplayName", 
    "TaskLogPath", 
    "TaskOutcome", 
    "SucceededCount", 
    "SucceededWithIssuesCount", 
    "FailedCount", 
    "CanceledCount", 
    "SkippedCount", 
    "AbandonedCount", 
    "ActivityDurationSeconds", 
    "PipelineRunOutcome", 
    "ActivityType", 
    "RelativeStartTimeFromJobSeconds", 
    "RelativeStartTimeFromStageSeconds", 
    "RelativeStartTimeFromRunSeconds"})
@JsonInclude(Include.NON_NULL)
public class PipelineRunActivityResult implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PipelineRunActivityResultSK")
    protected Integer pipelineRunActivityResultSK;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("PipelineRunId")
    protected Integer pipelineRunId;

    @JsonProperty("PipelineSK")
    protected Integer pipelineSK;

    @JsonProperty("PipelineTaskSK")
    protected Integer pipelineTaskSK;

    @JsonProperty("PipelineJobSK")
    protected Integer pipelineJobSK;

    @JsonProperty("BranchSK")
    protected Integer branchSK;

    @JsonProperty("PipelineRunQueuedDateSK")
    protected Integer pipelineRunQueuedDateSK;

    @JsonProperty("PipelineRunStartedDateSK")
    protected Integer pipelineRunStartedDateSK;

    @JsonProperty("PipelineRunCompletedDateSK")
    protected Integer pipelineRunCompletedDateSK;

    @JsonProperty("ActivityStartedDateSK")
    protected Integer activityStartedDateSK;

    @JsonProperty("ActivityStartedDate")
    protected OffsetDateTime activityStartedDate;

    @JsonProperty("ActivityCompletedDateSK")
    protected Integer activityCompletedDateSK;

    @JsonProperty("ActivityCompletedDate")
    protected OffsetDateTime activityCompletedDate;

    @JsonProperty("TaskDisplayName")
    protected String taskDisplayName;

    @JsonProperty("TaskLogPath")
    protected String taskLogPath;

    @JsonProperty("TaskOutcome")
    protected PipelineRunTaskOutcome taskOutcome;

    @JsonProperty("SucceededCount")
    protected Integer succeededCount;

    @JsonProperty("SucceededWithIssuesCount")
    protected Integer succeededWithIssuesCount;

    @JsonProperty("FailedCount")
    protected Integer failedCount;

    @JsonProperty("CanceledCount")
    protected Integer canceledCount;

    @JsonProperty("SkippedCount")
    protected Integer skippedCount;

    @JsonProperty("AbandonedCount")
    protected Integer abandonedCount;

    @JsonProperty("ActivityDurationSeconds")
    protected BigDecimal activityDurationSeconds;

    @JsonProperty("PipelineRunOutcome")
    protected PipelineRunOutcome pipelineRunOutcome;

    @JsonProperty("ActivityType")
    protected PipelineActivityType activityType;

    @JsonProperty("RelativeStartTimeFromJobSeconds")
    protected Integer relativeStartTimeFromJobSeconds;

    @JsonProperty("RelativeStartTimeFromStageSeconds")
    protected Integer relativeStartTimeFromStageSeconds;

    @JsonProperty("RelativeStartTimeFromRunSeconds")
    protected Integer relativeStartTimeFromRunSeconds;

    protected PipelineRunActivityResult() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer pipelineRunActivityResultSK;
        private String projectSK;
        private Integer pipelineRunId;
        private Integer pipelineSK;
        private Integer pipelineTaskSK;
        private Integer pipelineJobSK;
        private Integer branchSK;
        private Integer pipelineRunQueuedDateSK;
        private Integer pipelineRunStartedDateSK;
        private Integer pipelineRunCompletedDateSK;
        private Integer activityStartedDateSK;
        private OffsetDateTime activityStartedDate;
        private Integer activityCompletedDateSK;
        private OffsetDateTime activityCompletedDate;
        private String taskDisplayName;
        private String taskLogPath;
        private PipelineRunTaskOutcome taskOutcome;
        private Integer succeededCount;
        private Integer succeededWithIssuesCount;
        private Integer failedCount;
        private Integer canceledCount;
        private Integer skippedCount;
        private Integer abandonedCount;
        private BigDecimal activityDurationSeconds;
        private PipelineRunOutcome pipelineRunOutcome;
        private PipelineActivityType activityType;
        private Integer relativeStartTimeFromJobSeconds;
        private Integer relativeStartTimeFromStageSeconds;
        private Integer relativeStartTimeFromRunSeconds;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder pipelineRunActivityResultSK(Integer pipelineRunActivityResultSK) {
            this.pipelineRunActivityResultSK = pipelineRunActivityResultSK;
            this.changedFields = changedFields.add("PipelineRunActivityResultSK");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder pipelineRunId(Integer pipelineRunId) {
            this.pipelineRunId = pipelineRunId;
            this.changedFields = changedFields.add("PipelineRunId");
            return this;
        }

        public Builder pipelineSK(Integer pipelineSK) {
            this.pipelineSK = pipelineSK;
            this.changedFields = changedFields.add("PipelineSK");
            return this;
        }

        public Builder pipelineTaskSK(Integer pipelineTaskSK) {
            this.pipelineTaskSK = pipelineTaskSK;
            this.changedFields = changedFields.add("PipelineTaskSK");
            return this;
        }

        public Builder pipelineJobSK(Integer pipelineJobSK) {
            this.pipelineJobSK = pipelineJobSK;
            this.changedFields = changedFields.add("PipelineJobSK");
            return this;
        }

        public Builder branchSK(Integer branchSK) {
            this.branchSK = branchSK;
            this.changedFields = changedFields.add("BranchSK");
            return this;
        }

        public Builder pipelineRunQueuedDateSK(Integer pipelineRunQueuedDateSK) {
            this.pipelineRunQueuedDateSK = pipelineRunQueuedDateSK;
            this.changedFields = changedFields.add("PipelineRunQueuedDateSK");
            return this;
        }

        public Builder pipelineRunStartedDateSK(Integer pipelineRunStartedDateSK) {
            this.pipelineRunStartedDateSK = pipelineRunStartedDateSK;
            this.changedFields = changedFields.add("PipelineRunStartedDateSK");
            return this;
        }

        public Builder pipelineRunCompletedDateSK(Integer pipelineRunCompletedDateSK) {
            this.pipelineRunCompletedDateSK = pipelineRunCompletedDateSK;
            this.changedFields = changedFields.add("PipelineRunCompletedDateSK");
            return this;
        }

        public Builder activityStartedDateSK(Integer activityStartedDateSK) {
            this.activityStartedDateSK = activityStartedDateSK;
            this.changedFields = changedFields.add("ActivityStartedDateSK");
            return this;
        }

        public Builder activityStartedDate(OffsetDateTime activityStartedDate) {
            this.activityStartedDate = activityStartedDate;
            this.changedFields = changedFields.add("ActivityStartedDate");
            return this;
        }

        public Builder activityCompletedDateSK(Integer activityCompletedDateSK) {
            this.activityCompletedDateSK = activityCompletedDateSK;
            this.changedFields = changedFields.add("ActivityCompletedDateSK");
            return this;
        }

        public Builder activityCompletedDate(OffsetDateTime activityCompletedDate) {
            this.activityCompletedDate = activityCompletedDate;
            this.changedFields = changedFields.add("ActivityCompletedDate");
            return this;
        }

        public Builder taskDisplayName(String taskDisplayName) {
            this.taskDisplayName = taskDisplayName;
            this.changedFields = changedFields.add("TaskDisplayName");
            return this;
        }

        public Builder taskLogPath(String taskLogPath) {
            this.taskLogPath = taskLogPath;
            this.changedFields = changedFields.add("TaskLogPath");
            return this;
        }

        public Builder taskOutcome(PipelineRunTaskOutcome taskOutcome) {
            this.taskOutcome = taskOutcome;
            this.changedFields = changedFields.add("TaskOutcome");
            return this;
        }

        public Builder succeededCount(Integer succeededCount) {
            this.succeededCount = succeededCount;
            this.changedFields = changedFields.add("SucceededCount");
            return this;
        }

        public Builder succeededWithIssuesCount(Integer succeededWithIssuesCount) {
            this.succeededWithIssuesCount = succeededWithIssuesCount;
            this.changedFields = changedFields.add("SucceededWithIssuesCount");
            return this;
        }

        public Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            this.changedFields = changedFields.add("FailedCount");
            return this;
        }

        public Builder canceledCount(Integer canceledCount) {
            this.canceledCount = canceledCount;
            this.changedFields = changedFields.add("CanceledCount");
            return this;
        }

        public Builder skippedCount(Integer skippedCount) {
            this.skippedCount = skippedCount;
            this.changedFields = changedFields.add("SkippedCount");
            return this;
        }

        public Builder abandonedCount(Integer abandonedCount) {
            this.abandonedCount = abandonedCount;
            this.changedFields = changedFields.add("AbandonedCount");
            return this;
        }

        public Builder activityDurationSeconds(BigDecimal activityDurationSeconds) {
            this.activityDurationSeconds = activityDurationSeconds;
            this.changedFields = changedFields.add("ActivityDurationSeconds");
            return this;
        }

        public Builder pipelineRunOutcome(PipelineRunOutcome pipelineRunOutcome) {
            this.pipelineRunOutcome = pipelineRunOutcome;
            this.changedFields = changedFields.add("PipelineRunOutcome");
            return this;
        }

        public Builder activityType(PipelineActivityType activityType) {
            this.activityType = activityType;
            this.changedFields = changedFields.add("ActivityType");
            return this;
        }

        public Builder relativeStartTimeFromJobSeconds(Integer relativeStartTimeFromJobSeconds) {
            this.relativeStartTimeFromJobSeconds = relativeStartTimeFromJobSeconds;
            this.changedFields = changedFields.add("RelativeStartTimeFromJobSeconds");
            return this;
        }

        public Builder relativeStartTimeFromStageSeconds(Integer relativeStartTimeFromStageSeconds) {
            this.relativeStartTimeFromStageSeconds = relativeStartTimeFromStageSeconds;
            this.changedFields = changedFields.add("RelativeStartTimeFromStageSeconds");
            return this;
        }

        public Builder relativeStartTimeFromRunSeconds(Integer relativeStartTimeFromRunSeconds) {
            this.relativeStartTimeFromRunSeconds = relativeStartTimeFromRunSeconds;
            this.changedFields = changedFields.add("RelativeStartTimeFromRunSeconds");
            return this;
        }

        public PipelineRunActivityResult build() {
            PipelineRunActivityResult _x = new PipelineRunActivityResult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult";
            _x.pipelineRunActivityResultSK = pipelineRunActivityResultSK;
            _x.projectSK = projectSK;
            _x.pipelineRunId = pipelineRunId;
            _x.pipelineSK = pipelineSK;
            _x.pipelineTaskSK = pipelineTaskSK;
            _x.pipelineJobSK = pipelineJobSK;
            _x.branchSK = branchSK;
            _x.pipelineRunQueuedDateSK = pipelineRunQueuedDateSK;
            _x.pipelineRunStartedDateSK = pipelineRunStartedDateSK;
            _x.pipelineRunCompletedDateSK = pipelineRunCompletedDateSK;
            _x.activityStartedDateSK = activityStartedDateSK;
            _x.activityStartedDate = activityStartedDate;
            _x.activityCompletedDateSK = activityCompletedDateSK;
            _x.activityCompletedDate = activityCompletedDate;
            _x.taskDisplayName = taskDisplayName;
            _x.taskLogPath = taskLogPath;
            _x.taskOutcome = taskOutcome;
            _x.succeededCount = succeededCount;
            _x.succeededWithIssuesCount = succeededWithIssuesCount;
            _x.failedCount = failedCount;
            _x.canceledCount = canceledCount;
            _x.skippedCount = skippedCount;
            _x.abandonedCount = abandonedCount;
            _x.activityDurationSeconds = activityDurationSeconds;
            _x.pipelineRunOutcome = pipelineRunOutcome;
            _x.activityType = activityType;
            _x.relativeStartTimeFromJobSeconds = relativeStartTimeFromJobSeconds;
            _x.relativeStartTimeFromStageSeconds = relativeStartTimeFromStageSeconds;
            _x.relativeStartTimeFromRunSeconds = relativeStartTimeFromRunSeconds;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && pipelineRunActivityResultSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(pipelineRunActivityResultSK.toString()));
        }
    }

    @Property(name="PipelineRunActivityResultSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunActivityResultSK() {
        return Optional.ofNullable(pipelineRunActivityResultSK);
    }

    public PipelineRunActivityResult withPipelineRunActivityResultSK(Integer pipelineRunActivityResultSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunActivityResultSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunActivityResultSK = pipelineRunActivityResultSK;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public PipelineRunActivityResult withProjectSK(String projectSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="PipelineRunId")
    @JsonIgnore
    public Optional<Integer> getPipelineRunId() {
        return Optional.ofNullable(pipelineRunId);
    }

    public PipelineRunActivityResult withPipelineRunId(Integer pipelineRunId) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunId = pipelineRunId;
        return _x;
    }

    @Property(name="PipelineSK")
    @JsonIgnore
    public Optional<Integer> getPipelineSK() {
        return Optional.ofNullable(pipelineSK);
    }

    public PipelineRunActivityResult withPipelineSK(Integer pipelineSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineSK = pipelineSK;
        return _x;
    }

    @Property(name="PipelineTaskSK")
    @JsonIgnore
    public Optional<Integer> getPipelineTaskSK() {
        return Optional.ofNullable(pipelineTaskSK);
    }

    public PipelineRunActivityResult withPipelineTaskSK(Integer pipelineTaskSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineTaskSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineTaskSK = pipelineTaskSK;
        return _x;
    }

    @Property(name="PipelineJobSK")
    @JsonIgnore
    public Optional<Integer> getPipelineJobSK() {
        return Optional.ofNullable(pipelineJobSK);
    }

    public PipelineRunActivityResult withPipelineJobSK(Integer pipelineJobSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineJobSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineJobSK = pipelineJobSK;
        return _x;
    }

    @Property(name="BranchSK")
    @JsonIgnore
    public Optional<Integer> getBranchSK() {
        return Optional.ofNullable(branchSK);
    }

    public PipelineRunActivityResult withBranchSK(Integer branchSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("BranchSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.branchSK = branchSK;
        return _x;
    }

    @Property(name="PipelineRunQueuedDateSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunQueuedDateSK() {
        return Optional.ofNullable(pipelineRunQueuedDateSK);
    }

    public PipelineRunActivityResult withPipelineRunQueuedDateSK(Integer pipelineRunQueuedDateSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunQueuedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunQueuedDateSK = pipelineRunQueuedDateSK;
        return _x;
    }

    @Property(name="PipelineRunStartedDateSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunStartedDateSK() {
        return Optional.ofNullable(pipelineRunStartedDateSK);
    }

    public PipelineRunActivityResult withPipelineRunStartedDateSK(Integer pipelineRunStartedDateSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunStartedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunStartedDateSK = pipelineRunStartedDateSK;
        return _x;
    }

    @Property(name="PipelineRunCompletedDateSK")
    @JsonIgnore
    public Optional<Integer> getPipelineRunCompletedDateSK() {
        return Optional.ofNullable(pipelineRunCompletedDateSK);
    }

    public PipelineRunActivityResult withPipelineRunCompletedDateSK(Integer pipelineRunCompletedDateSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunCompletedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunCompletedDateSK = pipelineRunCompletedDateSK;
        return _x;
    }

    @Property(name="ActivityStartedDateSK")
    @JsonIgnore
    public Optional<Integer> getActivityStartedDateSK() {
        return Optional.ofNullable(activityStartedDateSK);
    }

    public PipelineRunActivityResult withActivityStartedDateSK(Integer activityStartedDateSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityStartedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityStartedDateSK = activityStartedDateSK;
        return _x;
    }

    @Property(name="ActivityStartedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityStartedDate() {
        return Optional.ofNullable(activityStartedDate);
    }

    public PipelineRunActivityResult withActivityStartedDate(OffsetDateTime activityStartedDate) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityStartedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityStartedDate = activityStartedDate;
        return _x;
    }

    @Property(name="ActivityCompletedDateSK")
    @JsonIgnore
    public Optional<Integer> getActivityCompletedDateSK() {
        return Optional.ofNullable(activityCompletedDateSK);
    }

    public PipelineRunActivityResult withActivityCompletedDateSK(Integer activityCompletedDateSK) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityCompletedDateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityCompletedDateSK = activityCompletedDateSK;
        return _x;
    }

    @Property(name="ActivityCompletedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityCompletedDate() {
        return Optional.ofNullable(activityCompletedDate);
    }

    public PipelineRunActivityResult withActivityCompletedDate(OffsetDateTime activityCompletedDate) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityCompletedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityCompletedDate = activityCompletedDate;
        return _x;
    }

    @Property(name="TaskDisplayName")
    @JsonIgnore
    public Optional<String> getTaskDisplayName() {
        return Optional.ofNullable(taskDisplayName);
    }

    public PipelineRunActivityResult withTaskDisplayName(String taskDisplayName) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("TaskDisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.taskDisplayName = taskDisplayName;
        return _x;
    }

    @Property(name="TaskLogPath")
    @JsonIgnore
    public Optional<String> getTaskLogPath() {
        return Optional.ofNullable(taskLogPath);
    }

    public PipelineRunActivityResult withTaskLogPath(String taskLogPath) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("TaskLogPath");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.taskLogPath = taskLogPath;
        return _x;
    }

    @Property(name="TaskOutcome")
    @JsonIgnore
    public Optional<PipelineRunTaskOutcome> getTaskOutcome() {
        return Optional.ofNullable(taskOutcome);
    }

    public PipelineRunActivityResult withTaskOutcome(PipelineRunTaskOutcome taskOutcome) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("TaskOutcome");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.taskOutcome = taskOutcome;
        return _x;
    }

    @Property(name="SucceededCount")
    @JsonIgnore
    public Optional<Integer> getSucceededCount() {
        return Optional.ofNullable(succeededCount);
    }

    public PipelineRunActivityResult withSucceededCount(Integer succeededCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("SucceededCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.succeededCount = succeededCount;
        return _x;
    }

    @Property(name="SucceededWithIssuesCount")
    @JsonIgnore
    public Optional<Integer> getSucceededWithIssuesCount() {
        return Optional.ofNullable(succeededWithIssuesCount);
    }

    public PipelineRunActivityResult withSucceededWithIssuesCount(Integer succeededWithIssuesCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("SucceededWithIssuesCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.succeededWithIssuesCount = succeededWithIssuesCount;
        return _x;
    }

    @Property(name="FailedCount")
    @JsonIgnore
    public Optional<Integer> getFailedCount() {
        return Optional.ofNullable(failedCount);
    }

    public PipelineRunActivityResult withFailedCount(Integer failedCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("FailedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.failedCount = failedCount;
        return _x;
    }

    @Property(name="CanceledCount")
    @JsonIgnore
    public Optional<Integer> getCanceledCount() {
        return Optional.ofNullable(canceledCount);
    }

    public PipelineRunActivityResult withCanceledCount(Integer canceledCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("CanceledCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.canceledCount = canceledCount;
        return _x;
    }

    @Property(name="SkippedCount")
    @JsonIgnore
    public Optional<Integer> getSkippedCount() {
        return Optional.ofNullable(skippedCount);
    }

    public PipelineRunActivityResult withSkippedCount(Integer skippedCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("SkippedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.skippedCount = skippedCount;
        return _x;
    }

    @Property(name="AbandonedCount")
    @JsonIgnore
    public Optional<Integer> getAbandonedCount() {
        return Optional.ofNullable(abandonedCount);
    }

    public PipelineRunActivityResult withAbandonedCount(Integer abandonedCount) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("AbandonedCount");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.abandonedCount = abandonedCount;
        return _x;
    }

    @Property(name="ActivityDurationSeconds")
    @JsonIgnore
    public Optional<BigDecimal> getActivityDurationSeconds() {
        return Optional.ofNullable(activityDurationSeconds);
    }

    public PipelineRunActivityResult withActivityDurationSeconds(BigDecimal activityDurationSeconds) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityDurationSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityDurationSeconds = activityDurationSeconds;
        return _x;
    }

    @Property(name="PipelineRunOutcome")
    @JsonIgnore
    public Optional<PipelineRunOutcome> getPipelineRunOutcome() {
        return Optional.ofNullable(pipelineRunOutcome);
    }

    public PipelineRunActivityResult withPipelineRunOutcome(PipelineRunOutcome pipelineRunOutcome) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("PipelineRunOutcome");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.pipelineRunOutcome = pipelineRunOutcome;
        return _x;
    }

    @Property(name="ActivityType")
    @JsonIgnore
    public Optional<PipelineActivityType> getActivityType() {
        return Optional.ofNullable(activityType);
    }

    public PipelineRunActivityResult withActivityType(PipelineActivityType activityType) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("ActivityType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.activityType = activityType;
        return _x;
    }

    @Property(name="RelativeStartTimeFromJobSeconds")
    @JsonIgnore
    public Optional<Integer> getRelativeStartTimeFromJobSeconds() {
        return Optional.ofNullable(relativeStartTimeFromJobSeconds);
    }

    public PipelineRunActivityResult withRelativeStartTimeFromJobSeconds(Integer relativeStartTimeFromJobSeconds) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("RelativeStartTimeFromJobSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.relativeStartTimeFromJobSeconds = relativeStartTimeFromJobSeconds;
        return _x;
    }

    @Property(name="RelativeStartTimeFromStageSeconds")
    @JsonIgnore
    public Optional<Integer> getRelativeStartTimeFromStageSeconds() {
        return Optional.ofNullable(relativeStartTimeFromStageSeconds);
    }

    public PipelineRunActivityResult withRelativeStartTimeFromStageSeconds(Integer relativeStartTimeFromStageSeconds) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("RelativeStartTimeFromStageSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.relativeStartTimeFromStageSeconds = relativeStartTimeFromStageSeconds;
        return _x;
    }

    @Property(name="RelativeStartTimeFromRunSeconds")
    @JsonIgnore
    public Optional<Integer> getRelativeStartTimeFromRunSeconds() {
        return Optional.ofNullable(relativeStartTimeFromRunSeconds);
    }

    public PipelineRunActivityResult withRelativeStartTimeFromRunSeconds(Integer relativeStartTimeFromRunSeconds) {
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = changedFields.add("RelativeStartTimeFromRunSeconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.PipelineRunActivityResult");
        _x.relativeStartTimeFromRunSeconds = relativeStartTimeFromRunSeconds;
        return _x;
    }

    public PipelineRunActivityResult withUnmappedField(String name, String value) {
        PipelineRunActivityResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="Pipeline")
    @JsonIgnore
    public PipelineRequest getPipeline() {
        return new PipelineRequest(contextPath.addSegment("Pipeline"), RequestHelper.getValue(unmappedFields, "Pipeline"));
    }

    @NavigationProperty(name="PipelineTask")
    @JsonIgnore
    public PipelineTaskRequest getPipelineTask() {
        return new PipelineTaskRequest(contextPath.addSegment("PipelineTask"), RequestHelper.getValue(unmappedFields, "PipelineTask"));
    }

    @NavigationProperty(name="PipelineJob")
    @JsonIgnore
    public PipelineJobRequest getPipelineJob() {
        return new PipelineJobRequest(contextPath.addSegment("PipelineJob"), RequestHelper.getValue(unmappedFields, "PipelineJob"));
    }

    @NavigationProperty(name="Branch")
    @JsonIgnore
    public BranchRequest getBranch() {
        return new BranchRequest(contextPath.addSegment("Branch"), RequestHelper.getValue(unmappedFields, "Branch"));
    }

    @NavigationProperty(name="PipelineRunQueuedOn")
    @JsonIgnore
    public CalendarDateRequest getPipelineRunQueuedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunQueuedOn"), RequestHelper.getValue(unmappedFields, "PipelineRunQueuedOn"));
    }

    @NavigationProperty(name="PipelineRunStartedOn")
    @JsonIgnore
    public CalendarDateRequest getPipelineRunStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunStartedOn"), RequestHelper.getValue(unmappedFields, "PipelineRunStartedOn"));
    }

    @NavigationProperty(name="PipelineRunCompletedOn")
    @JsonIgnore
    public CalendarDateRequest getPipelineRunCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("PipelineRunCompletedOn"), RequestHelper.getValue(unmappedFields, "PipelineRunCompletedOn"));
    }

    @NavigationProperty(name="ActivityStartedOn")
    @JsonIgnore
    public CalendarDateRequest getActivityStartedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ActivityStartedOn"), RequestHelper.getValue(unmappedFields, "ActivityStartedOn"));
    }

    @NavigationProperty(name="ActivityCompletedOn")
    @JsonIgnore
    public CalendarDateRequest getActivityCompletedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ActivityCompletedOn"), RequestHelper.getValue(unmappedFields, "ActivityCompletedOn"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineRunActivityResult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PipelineRunActivityResult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PipelineRunActivityResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PipelineRunActivityResult _copy() {
        PipelineRunActivityResult _x = new PipelineRunActivityResult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.pipelineRunActivityResultSK = pipelineRunActivityResultSK;
        _x.projectSK = projectSK;
        _x.pipelineRunId = pipelineRunId;
        _x.pipelineSK = pipelineSK;
        _x.pipelineTaskSK = pipelineTaskSK;
        _x.pipelineJobSK = pipelineJobSK;
        _x.branchSK = branchSK;
        _x.pipelineRunQueuedDateSK = pipelineRunQueuedDateSK;
        _x.pipelineRunStartedDateSK = pipelineRunStartedDateSK;
        _x.pipelineRunCompletedDateSK = pipelineRunCompletedDateSK;
        _x.activityStartedDateSK = activityStartedDateSK;
        _x.activityStartedDate = activityStartedDate;
        _x.activityCompletedDateSK = activityCompletedDateSK;
        _x.activityCompletedDate = activityCompletedDate;
        _x.taskDisplayName = taskDisplayName;
        _x.taskLogPath = taskLogPath;
        _x.taskOutcome = taskOutcome;
        _x.succeededCount = succeededCount;
        _x.succeededWithIssuesCount = succeededWithIssuesCount;
        _x.failedCount = failedCount;
        _x.canceledCount = canceledCount;
        _x.skippedCount = skippedCount;
        _x.abandonedCount = abandonedCount;
        _x.activityDurationSeconds = activityDurationSeconds;
        _x.pipelineRunOutcome = pipelineRunOutcome;
        _x.activityType = activityType;
        _x.relativeStartTimeFromJobSeconds = relativeStartTimeFromJobSeconds;
        _x.relativeStartTimeFromStageSeconds = relativeStartTimeFromStageSeconds;
        _x.relativeStartTimeFromRunSeconds = relativeStartTimeFromRunSeconds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PipelineRunActivityResult[");
        b.append("PipelineRunActivityResultSK=");
        b.append(this.pipelineRunActivityResultSK);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("PipelineRunId=");
        b.append(this.pipelineRunId);
        b.append(", ");
        b.append("PipelineSK=");
        b.append(this.pipelineSK);
        b.append(", ");
        b.append("PipelineTaskSK=");
        b.append(this.pipelineTaskSK);
        b.append(", ");
        b.append("PipelineJobSK=");
        b.append(this.pipelineJobSK);
        b.append(", ");
        b.append("BranchSK=");
        b.append(this.branchSK);
        b.append(", ");
        b.append("PipelineRunQueuedDateSK=");
        b.append(this.pipelineRunQueuedDateSK);
        b.append(", ");
        b.append("PipelineRunStartedDateSK=");
        b.append(this.pipelineRunStartedDateSK);
        b.append(", ");
        b.append("PipelineRunCompletedDateSK=");
        b.append(this.pipelineRunCompletedDateSK);
        b.append(", ");
        b.append("ActivityStartedDateSK=");
        b.append(this.activityStartedDateSK);
        b.append(", ");
        b.append("ActivityStartedDate=");
        b.append(this.activityStartedDate);
        b.append(", ");
        b.append("ActivityCompletedDateSK=");
        b.append(this.activityCompletedDateSK);
        b.append(", ");
        b.append("ActivityCompletedDate=");
        b.append(this.activityCompletedDate);
        b.append(", ");
        b.append("TaskDisplayName=");
        b.append(this.taskDisplayName);
        b.append(", ");
        b.append("TaskLogPath=");
        b.append(this.taskLogPath);
        b.append(", ");
        b.append("TaskOutcome=");
        b.append(this.taskOutcome);
        b.append(", ");
        b.append("SucceededCount=");
        b.append(this.succeededCount);
        b.append(", ");
        b.append("SucceededWithIssuesCount=");
        b.append(this.succeededWithIssuesCount);
        b.append(", ");
        b.append("FailedCount=");
        b.append(this.failedCount);
        b.append(", ");
        b.append("CanceledCount=");
        b.append(this.canceledCount);
        b.append(", ");
        b.append("SkippedCount=");
        b.append(this.skippedCount);
        b.append(", ");
        b.append("AbandonedCount=");
        b.append(this.abandonedCount);
        b.append(", ");
        b.append("ActivityDurationSeconds=");
        b.append(this.activityDurationSeconds);
        b.append(", ");
        b.append("PipelineRunOutcome=");
        b.append(this.pipelineRunOutcome);
        b.append(", ");
        b.append("ActivityType=");
        b.append(this.activityType);
        b.append(", ");
        b.append("RelativeStartTimeFromJobSeconds=");
        b.append(this.relativeStartTimeFromJobSeconds);
        b.append(", ");
        b.append("RelativeStartTimeFromStageSeconds=");
        b.append(this.relativeStartTimeFromStageSeconds);
        b.append(", ");
        b.append("RelativeStartTimeFromRunSeconds=");
        b.append(this.relativeStartTimeFromRunSeconds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
