package microsoft.vs.analytics.v3.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v3.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v3.model.enums.PipelineProcessType;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "PipelineSK", 
    "PipelineId", 
    "PipelineName", 
    "PipelineVersion", 
    "PipelineProcessType"})
@JsonInclude(Include.NON_NULL)
public class Pipeline implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("PipelineSK")
    protected Integer pipelineSK;

    @JsonProperty("PipelineId")
    protected Integer pipelineId;

    @JsonProperty("PipelineName")
    protected String pipelineName;

    @JsonProperty("PipelineVersion")
    protected Integer pipelineVersion;

    @JsonProperty("PipelineProcessType")
    protected PipelineProcessType pipelineProcessType;

    protected Pipeline() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer pipelineSK;
        private Integer pipelineId;
        private String pipelineName;
        private Integer pipelineVersion;
        private PipelineProcessType pipelineProcessType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder pipelineSK(Integer pipelineSK) {
            this.pipelineSK = pipelineSK;
            this.changedFields = changedFields.add("PipelineSK");
            return this;
        }

        public Builder pipelineId(Integer pipelineId) {
            this.pipelineId = pipelineId;
            this.changedFields = changedFields.add("PipelineId");
            return this;
        }

        public Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            this.changedFields = changedFields.add("PipelineName");
            return this;
        }

        public Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            this.changedFields = changedFields.add("PipelineVersion");
            return this;
        }

        public Builder pipelineProcessType(PipelineProcessType pipelineProcessType) {
            this.pipelineProcessType = pipelineProcessType;
            this.changedFields = changedFields.add("PipelineProcessType");
            return this;
        }

        public Pipeline build() {
            Pipeline _x = new Pipeline();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline";
            _x.projectSK = projectSK;
            _x.pipelineSK = pipelineSK;
            _x.pipelineId = pipelineId;
            _x.pipelineName = pipelineName;
            _x.pipelineVersion = pipelineVersion;
            _x.pipelineProcessType = pipelineProcessType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && pipelineSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(pipelineSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Pipeline withProjectSK(String projectSK) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="PipelineSK")
    @JsonIgnore
    public Optional<Integer> getPipelineSK() {
        return Optional.ofNullable(pipelineSK);
    }

    public Pipeline withPipelineSK(Integer pipelineSK) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("PipelineSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.pipelineSK = pipelineSK;
        return _x;
    }

    @Property(name="PipelineId")
    @JsonIgnore
    public Optional<Integer> getPipelineId() {
        return Optional.ofNullable(pipelineId);
    }

    public Pipeline withPipelineId(Integer pipelineId) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("PipelineId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.pipelineId = pipelineId;
        return _x;
    }

    @Property(name="PipelineName")
    @JsonIgnore
    public Optional<String> getPipelineName() {
        return Optional.ofNullable(pipelineName);
    }

    public Pipeline withPipelineName(String pipelineName) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("PipelineName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.pipelineName = pipelineName;
        return _x;
    }

    @Property(name="PipelineVersion")
    @JsonIgnore
    public Optional<Integer> getPipelineVersion() {
        return Optional.ofNullable(pipelineVersion);
    }

    public Pipeline withPipelineVersion(Integer pipelineVersion) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("PipelineVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.pipelineVersion = pipelineVersion;
        return _x;
    }

    @Property(name="PipelineProcessType")
    @JsonIgnore
    public Optional<PipelineProcessType> getPipelineProcessType() {
        return Optional.ofNullable(pipelineProcessType);
    }

    public Pipeline withPipelineProcessType(PipelineProcessType pipelineProcessType) {
        Pipeline _x = _copy();
        _x.changedFields = changedFields.add("PipelineProcessType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Pipeline");
        _x.pipelineProcessType = pipelineProcessType;
        return _x;
    }

    public Pipeline withUnmappedField(String name, String value) {
        Pipeline _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Pipeline patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Pipeline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Pipeline put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Pipeline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Pipeline _copy() {
        Pipeline _x = new Pipeline();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.pipelineSK = pipelineSK;
        _x.pipelineId = pipelineId;
        _x.pipelineName = pipelineName;
        _x.pipelineVersion = pipelineVersion;
        _x.pipelineProcessType = pipelineProcessType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Pipeline[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("PipelineSK=");
        b.append(this.pipelineSK);
        b.append(", ");
        b.append("PipelineId=");
        b.append(this.pipelineId);
        b.append(", ");
        b.append("PipelineName=");
        b.append(this.pipelineName);
        b.append(", ");
        b.append("PipelineVersion=");
        b.append(this.pipelineVersion);
        b.append(", ");
        b.append("PipelineProcessType=");
        b.append(this.pipelineProcessType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
