package microsoft.vs.analytics.v2.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.collection.request.WorkItemCollectionRequest;

public final class WorkItems extends WorkItemCollectionRequest {

    public WorkItems(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public BoardLocations boardLocations() {
        return new BoardLocations(contextPath.addSegment("BoardLocations"));
    }

    public Teams teams() {
        return new Teams(contextPath.addSegment("Teams"));
    }

    public Dates inProgressOn() {
        return new Dates(contextPath.addSegment("InProgressOn"));
    }

    public Dates completedOn() {
        return new Dates(contextPath.addSegment("CompletedOn"));
    }

    public WorkItemRevisions revisions() {
        return new WorkItemRevisions(contextPath.addSegment("Revisions"));
    }

    public WorkItemLinks links() {
        return new WorkItemLinks(contextPath.addSegment("Links"));
    }

    public WorkItems children() {
        return new WorkItems(contextPath.addSegment("Children"));
    }

    public WorkItems parent() {
        return new WorkItems(contextPath.addSegment("Parent"));
    }

    public Processes processes() {
        return new Processes(contextPath.addSegment("Processes"));
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public Areas area() {
        return new Areas(contextPath.addSegment("Area"));
    }

    public Iterations iteration() {
        return new Iterations(contextPath.addSegment("Iteration"));
    }

    public Users assignedTo() {
        return new Users(contextPath.addSegment("AssignedTo"));
    }

    public Users changedBy() {
        return new Users(contextPath.addSegment("ChangedBy"));
    }

    public Users createdBy() {
        return new Users(contextPath.addSegment("CreatedBy"));
    }

    public Users activatedBy() {
        return new Users(contextPath.addSegment("ActivatedBy"));
    }

    public Users closedBy() {
        return new Users(contextPath.addSegment("ClosedBy"));
    }

    public Users resolvedBy() {
        return new Users(contextPath.addSegment("ResolvedBy"));
    }

    public Tags tags() {
        return new Tags(contextPath.addSegment("Tags"));
    }

    public Dates changedOn() {
        return new Dates(contextPath.addSegment("ChangedOn"));
    }

    public Dates closedOn() {
        return new Dates(contextPath.addSegment("ClosedOn"));
    }

    public Dates createdOn() {
        return new Dates(contextPath.addSegment("CreatedOn"));
    }

    public Dates resolvedOn() {
        return new Dates(contextPath.addSegment("ResolvedOn"));
    }

    public Dates stateChangeOn() {
        return new Dates(contextPath.addSegment("StateChangeOn"));
    }
}
