package microsoft.vs.analytics.v2.myorg.container;

import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;

import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.request.AreaRequest;
import microsoft.vs.analytics.v2.model.entity.request.BoardLocationRequest;
import microsoft.vs.analytics.v2.model.entity.request.CalendarDateRequest;
import microsoft.vs.analytics.v2.model.entity.request.IterationRequest;
import microsoft.vs.analytics.v2.model.entity.request.ProcessRequest;
import microsoft.vs.analytics.v2.model.entity.request.ProjectRequest;
import microsoft.vs.analytics.v2.model.entity.request.TagRequest;
import microsoft.vs.analytics.v2.model.entity.request.TeamRequest;
import microsoft.vs.analytics.v2.model.entity.request.UserRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemBoardSnapshotRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemLinkRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemRevisionRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemSnapshotRequest;
import microsoft.vs.analytics.v2.model.entity.request.WorkItemTypeFieldRequest;
import microsoft.vs.analytics.v2.myorg.entity.set.Areas;
import microsoft.vs.analytics.v2.myorg.entity.set.BoardLocations;
import microsoft.vs.analytics.v2.myorg.entity.set.Dates;
import microsoft.vs.analytics.v2.myorg.entity.set.Iterations;
import microsoft.vs.analytics.v2.myorg.entity.set.Processes;
import microsoft.vs.analytics.v2.myorg.entity.set.Projects;
import microsoft.vs.analytics.v2.myorg.entity.set.Tags;
import microsoft.vs.analytics.v2.myorg.entity.set.Teams;
import microsoft.vs.analytics.v2.myorg.entity.set.Users;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItemBoardSnapshot;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItemLinks;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItemRevisions;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItemSnapshot;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItemTypeFields;
import microsoft.vs.analytics.v2.myorg.entity.set.WorkItems;

public final class Container implements HasContext {

    private final ContextPath contextPath;

    public Container(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<Container> {

        @Override
        public Container _create(Context context) {
            return new Container(context);
        }
    }

    public static BuilderBase<ContainerBuilder<Container>, Container> test() {
        return new ContainerBuilderImpl();
    }

    public WorkItemRevisions workItemRevisions() {
        return new WorkItemRevisions(
                        contextPath.addSegment("WorkItemRevisions"));
    }

    public WorkItemRevisionRequest workItemRevisions(Integer revision, Integer workItemId) {
        return new WorkItemRevisionRequest(contextPath.addSegment("WorkItemRevisions").addKeys(new NameValue("Revision", revision), new NameValue("WorkItemId", workItemId)), Optional.empty());
    }

    public WorkItems workItems() {
        return new WorkItems(
                        contextPath.addSegment("WorkItems"));
    }

    public WorkItemRequest workItems(Integer workItemId) {
        return new WorkItemRequest(contextPath.addSegment("WorkItems").addKeys(new NameValue(workItemId.toString())), Optional.empty());
    }

    public WorkItemSnapshot workItemSnapshot() {
        return new WorkItemSnapshot(
                        contextPath.addSegment("WorkItemSnapshot"));
    }

    public WorkItemSnapshotRequest workItemSnapshot(Integer dateSK, Integer workItemId) {
        return new WorkItemSnapshotRequest(contextPath.addSegment("WorkItemSnapshot").addKeys(new NameValue("DateSK", dateSK), new NameValue("WorkItemId", workItemId)), Optional.empty());
    }

    public WorkItemBoardSnapshot workItemBoardSnapshot() {
        return new WorkItemBoardSnapshot(
                        contextPath.addSegment("WorkItemBoardSnapshot"));
    }

    public WorkItemBoardSnapshotRequest workItemBoardSnapshot(Integer boardLocationSK, Integer dateSK, Integer workItemId) {
        return new WorkItemBoardSnapshotRequest(contextPath.addSegment("WorkItemBoardSnapshot").addKeys(new NameValue("BoardLocationSK", boardLocationSK), new NameValue("DateSK", dateSK), new NameValue("WorkItemId", workItemId)), Optional.empty());
    }

    public WorkItemLinks workItemLinks() {
        return new WorkItemLinks(
                        contextPath.addSegment("WorkItemLinks"));
    }

    public WorkItemLinkRequest workItemLinks(Integer workItemLinkSK) {
        return new WorkItemLinkRequest(contextPath.addSegment("WorkItemLinks").addKeys(new NameValue(workItemLinkSK.toString())), Optional.empty());
    }

    public Dates dates() {
        return new Dates(
                        contextPath.addSegment("Dates"));
    }

    public CalendarDateRequest dates(Integer dateSK) {
        return new CalendarDateRequest(contextPath.addSegment("Dates").addKeys(new NameValue(dateSK.toString())), Optional.empty());
    }

    public Projects projects() {
        return new Projects(
                        contextPath.addSegment("Projects"));
    }

    public ProjectRequest projects(String projectSK) {
        return new ProjectRequest(contextPath.addSegment("Projects").addKeys(new NameValue(projectSK.toString())), Optional.empty());
    }

    public Iterations iterations() {
        return new Iterations(
                        contextPath.addSegment("Iterations"));
    }

    public IterationRequest iterations(String iterationSK) {
        return new IterationRequest(contextPath.addSegment("Iterations").addKeys(new NameValue(iterationSK.toString())), Optional.empty());
    }

    public Areas areas() {
        return new Areas(
                        contextPath.addSegment("Areas"));
    }

    public AreaRequest areas(String areaSK) {
        return new AreaRequest(contextPath.addSegment("Areas").addKeys(new NameValue(areaSK.toString())), Optional.empty());
    }

    public Tags tags() {
        return new Tags(
                        contextPath.addSegment("Tags"));
    }

    public TagRequest tags(Integer tagSK) {
        return new TagRequest(contextPath.addSegment("Tags").addKeys(new NameValue(tagSK.toString())), Optional.empty());
    }

    public Teams teams() {
        return new Teams(
                        contextPath.addSegment("Teams"));
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

    public BoardLocations boardLocations() {
        return new BoardLocations(
                        contextPath.addSegment("BoardLocations"));
    }

    public BoardLocationRequest boardLocations(Integer boardLocationSK) {
        return new BoardLocationRequest(contextPath.addSegment("BoardLocations").addKeys(new NameValue(boardLocationSK.toString())), Optional.empty());
    }

    public Users users() {
        return new Users(
                        contextPath.addSegment("Users"));
    }

    public UserRequest users(String userSK) {
        return new UserRequest(contextPath.addSegment("Users").addKeys(new NameValue(userSK.toString())), Optional.empty());
    }

    public WorkItemTypeFields workItemTypeFields() {
        return new WorkItemTypeFields(
                        contextPath.addSegment("WorkItemTypeFields"));
    }

    public WorkItemTypeFieldRequest workItemTypeFields(String fieldName, String projectSK, String workItemType) {
        return new WorkItemTypeFieldRequest(contextPath.addSegment("WorkItemTypeFields").addKeys(new NameValue("FieldName", fieldName), new NameValue("ProjectSK", projectSK), new NameValue("WorkItemType", workItemType)), Optional.empty());
    }

    public Processes processes() {
        return new Processes(
                        contextPath.addSegment("Processes"));
    }

    public ProcessRequest processes(Integer processSK) {
        return new ProcessRequest(contextPath.addSegment("Processes").addKeys(new NameValue(processSK.toString())), Optional.empty());
    }

}
