package microsoft.vs.analytics.v2.model.schema;

import com.github.davidmoten.odata.client.ODataType;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;

import microsoft.vs.analytics.v2.model.entity.Area;
import microsoft.vs.analytics.v2.model.entity.BoardLocation;
import microsoft.vs.analytics.v2.model.entity.CalendarDate;
import microsoft.vs.analytics.v2.model.entity.Iteration;
import microsoft.vs.analytics.v2.model.entity.Process;
import microsoft.vs.analytics.v2.model.entity.Project;
import microsoft.vs.analytics.v2.model.entity.Tag;
import microsoft.vs.analytics.v2.model.entity.Team;
import microsoft.vs.analytics.v2.model.entity.User;
import microsoft.vs.analytics.v2.model.entity.WorkItem;
import microsoft.vs.analytics.v2.model.entity.WorkItemBoardSnapshot;
import microsoft.vs.analytics.v2.model.entity.WorkItemLink;
import microsoft.vs.analytics.v2.model.entity.WorkItemRevision;
import microsoft.vs.analytics.v2.model.entity.WorkItemSnapshot;
import microsoft.vs.analytics.v2.model.entity.WorkItemTypeField;

public enum SchemaInfo implements com.github.davidmoten.odata.client.SchemaInfo {

    INSTANCE;

    private final Map<String, Class<? extends ODataType>> classes = new HashMap<>();

    private SchemaInfo() {
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItemRevision", WorkItemRevision.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItem", WorkItem.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItemSnapshot", WorkItemSnapshot.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItemBoardSnapshot", WorkItemBoardSnapshot.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItemLink", WorkItemLink.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate", CalendarDate.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Project", Project.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Iteration", Iteration.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Area", Area.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Tag", Tag.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Team", Team.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation", BoardLocation.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.User", User.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField", WorkItemTypeField.class);
        classes.put("Microsoft.VisualStudio.Services.Analytics.Model.Process", Process.class);
    }

    @Override
    public Class<? extends ODataType> getClassFromTypeWithNamespace(String name) {
        return classes.get(name);
    }

}
