package microsoft.vs.analytics.v2.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProjectVisibility implements Enum {

    @JsonProperty("Private")
    PRIVATE("Private", "0"),

    @JsonProperty("Organization")
    ORGANIZATION("Organization", "1"),

    @JsonProperty("Public")
    PUBLIC("Public", "2");

    private final String name;
    private final String value;

    private ProjectVisibility(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
