package microsoft.vs.analytics.v2.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.WorkItemSnapshot;
import microsoft.vs.analytics.v2.model.entity.collection.request.ProcessCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.collection.request.TagCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.collection.request.TeamCollectionRequest;

@JsonIgnoreType
public class WorkItemSnapshotRequest extends EntityRequest<WorkItemSnapshot> {

    public WorkItemSnapshotRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkItemSnapshot.class, contextPath, value, false);
    }

    public CalendarDateRequest date() {
        return new CalendarDateRequest(contextPath.addSegment("Date"), Optional.empty());
    }

    public CalendarDateRequest revisedOn() {
        return new CalendarDateRequest(contextPath.addSegment("RevisedOn"), Optional.empty());
    }

    public TeamCollectionRequest teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("Teams"), Optional.empty());
    }

    public TeamRequest teams(String teamSK) {
        return new TeamRequest(contextPath.addSegment("Teams").addKeys(new NameValue(teamSK.toString())), Optional.empty());
    }

    public ProcessCollectionRequest processes() {
        return new ProcessCollectionRequest(
                        contextPath.addSegment("Processes"), Optional.empty());
    }

    public ProcessRequest processes(Integer processSK) {
        return new ProcessRequest(contextPath.addSegment("Processes").addKeys(new NameValue(processSK.toString())), Optional.empty());
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

    public AreaRequest area() {
        return new AreaRequest(contextPath.addSegment("Area"), Optional.empty());
    }

    public IterationRequest iteration() {
        return new IterationRequest(contextPath.addSegment("Iteration"), Optional.empty());
    }

    public UserRequest assignedTo() {
        return new UserRequest(contextPath.addSegment("AssignedTo"), Optional.empty());
    }

    public UserRequest changedBy() {
        return new UserRequest(contextPath.addSegment("ChangedBy"), Optional.empty());
    }

    public UserRequest createdBy() {
        return new UserRequest(contextPath.addSegment("CreatedBy"), Optional.empty());
    }

    public UserRequest activatedBy() {
        return new UserRequest(contextPath.addSegment("ActivatedBy"), Optional.empty());
    }

    public UserRequest closedBy() {
        return new UserRequest(contextPath.addSegment("ClosedBy"), Optional.empty());
    }

    public UserRequest resolvedBy() {
        return new UserRequest(contextPath.addSegment("ResolvedBy"), Optional.empty());
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(
                        contextPath.addSegment("Tags"), Optional.empty());
    }

    public TagRequest tags(Integer tagSK) {
        return new TagRequest(contextPath.addSegment("Tags").addKeys(new NameValue(tagSK.toString())), Optional.empty());
    }

    public CalendarDateRequest changedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ChangedOn"), Optional.empty());
    }

    public CalendarDateRequest closedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ClosedOn"), Optional.empty());
    }

    public CalendarDateRequest createdOn() {
        return new CalendarDateRequest(contextPath.addSegment("CreatedOn"), Optional.empty());
    }

    public CalendarDateRequest resolvedOn() {
        return new CalendarDateRequest(contextPath.addSegment("ResolvedOn"), Optional.empty());
    }

    public CalendarDateRequest stateChangeOn() {
        return new CalendarDateRequest(contextPath.addSegment("StateChangeOn"), Optional.empty());
    }

    public CalendarDateRequest inProgressOn() {
        return new CalendarDateRequest(contextPath.addSegment("InProgressOn"), Optional.empty());
    }

    public CalendarDateRequest completedOn() {
        return new CalendarDateRequest(contextPath.addSegment("CompletedOn"), Optional.empty());
    }

    public UserRequest microsoft_VSTS_CodeReview_AcceptedBy() {
        return new UserRequest(contextPath.addSegment("Microsoft_VSTS_CodeReview_AcceptedBy"), Optional.empty());
    }

    public UserRequest microsoft_VSTS_Common_ReviewedBy() {
        return new UserRequest(contextPath.addSegment("Microsoft_VSTS_Common_ReviewedBy"), Optional.empty());
    }

}
