package microsoft.vs.analytics.v2.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.collection.request.AreaCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.collection.request.IterationCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "TeamSK", 
    "ProjectSK", 
    "TeamId", 
    "TeamName"})
@JsonInclude(Include.NON_NULL)
public class Team implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Team";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TeamSK")
    protected String teamSK;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TeamId")
    protected String teamId;

    @JsonProperty("TeamName")
    protected String teamName;

    protected Team() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String teamSK;
        private String projectSK;
        private String teamId;
        private String teamName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder teamSK(String teamSK) {
            this.teamSK = teamSK;
            this.changedFields = changedFields.add("TeamSK");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder teamId(String teamId) {
            this.teamId = teamId;
            this.changedFields = changedFields.add("TeamId");
            return this;
        }

        public Builder teamName(String teamName) {
            this.teamName = teamName;
            this.changedFields = changedFields.add("TeamName");
            return this;
        }

        public Team build() {
            Team _x = new Team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Team";
            _x.teamSK = teamSK;
            _x.projectSK = projectSK;
            _x.teamId = teamId;
            _x.teamName = teamName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teamSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teamSK.toString()));
        }
    }

    @Property(name="TeamSK")
    @JsonIgnore
    public Optional<String> getTeamSK() {
        return Optional.ofNullable(teamSK);
    }

    public Team withTeamSK(String teamSK) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("TeamSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Team");
        _x.teamSK = teamSK;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Team withProjectSK(String projectSK) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Team");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TeamId")
    @JsonIgnore
    public Optional<String> getTeamId() {
        return Optional.ofNullable(teamId);
    }

    public Team withTeamId(String teamId) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("TeamId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Team");
        _x.teamId = teamId;
        return _x;
    }

    @Property(name="TeamName")
    @JsonIgnore
    public Optional<String> getTeamName() {
        return Optional.ofNullable(teamName);
    }

    public Team withTeamName(String teamName) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("TeamName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Team");
        _x.teamName = teamName;
        return _x;
    }

    public Team withUnmappedField(String name, String value) {
        Team _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="Areas")
    @JsonIgnore
    public AreaCollectionRequest getAreas() {
        return new AreaCollectionRequest(
                        contextPath.addSegment("Areas"), RequestHelper.getValue(unmappedFields, "Areas"));
    }

    @NavigationProperty(name="Iterations")
    @JsonIgnore
    public IterationCollectionRequest getIterations() {
        return new IterationCollectionRequest(
                        contextPath.addSegment("Iterations"), RequestHelper.getValue(unmappedFields, "Iterations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Team _copy() {
        Team _x = new Team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.teamSK = teamSK;
        _x.projectSK = projectSK;
        _x.teamId = teamId;
        _x.teamName = teamName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Team[");
        b.append("TeamSK=");
        b.append(this.teamSK);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TeamId=");
        b.append(this.teamId);
        b.append(", ");
        b.append("TeamName=");
        b.append(this.teamName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
