package microsoft.vs.analytics.v2.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.collection.request.AreaCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.collection.request.IterationCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.collection.request.TeamCollectionRequest;
import microsoft.vs.analytics.v2.model.enums.ProjectVisibility;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "ProjectId", 
    "ProjectName", 
    "ProjectVisibility"})
@JsonInclude(Include.NON_NULL)
public class Project implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Project";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("ProjectId")
    protected String projectId;

    @JsonProperty("ProjectName")
    protected String projectName;

    @JsonProperty("ProjectVisibility")
    protected ProjectVisibility projectVisibility;

    protected Project() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private String projectId;
        private String projectName;
        private ProjectVisibility projectVisibility;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.changedFields = changedFields.add("ProjectId");
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            this.changedFields = changedFields.add("ProjectName");
            return this;
        }

        public Builder projectVisibility(ProjectVisibility projectVisibility) {
            this.projectVisibility = projectVisibility;
            this.changedFields = changedFields.add("ProjectVisibility");
            return this;
        }

        public Project build() {
            Project _x = new Project();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Project";
            _x.projectSK = projectSK;
            _x.projectId = projectId;
            _x.projectName = projectName;
            _x.projectVisibility = projectVisibility;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && projectSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(projectSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Project withProjectSK(String projectSK) {
        Project _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Project");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="ProjectId")
    @JsonIgnore
    public Optional<String> getProjectId() {
        return Optional.ofNullable(projectId);
    }

    public Project withProjectId(String projectId) {
        Project _x = _copy();
        _x.changedFields = changedFields.add("ProjectId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Project");
        _x.projectId = projectId;
        return _x;
    }

    @Property(name="ProjectName")
    @JsonIgnore
    public Optional<String> getProjectName() {
        return Optional.ofNullable(projectName);
    }

    public Project withProjectName(String projectName) {
        Project _x = _copy();
        _x.changedFields = changedFields.add("ProjectName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Project");
        _x.projectName = projectName;
        return _x;
    }

    @Property(name="ProjectVisibility")
    @JsonIgnore
    public Optional<ProjectVisibility> getProjectVisibility() {
        return Optional.ofNullable(projectVisibility);
    }

    public Project withProjectVisibility(ProjectVisibility projectVisibility) {
        Project _x = _copy();
        _x.changedFields = changedFields.add("ProjectVisibility");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Project");
        _x.projectVisibility = projectVisibility;
        return _x;
    }

    public Project withUnmappedField(String name, String value) {
        Project _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Areas")
    @JsonIgnore
    public AreaCollectionRequest getAreas() {
        return new AreaCollectionRequest(
                        contextPath.addSegment("Areas"), RequestHelper.getValue(unmappedFields, "Areas"));
    }

    @NavigationProperty(name="Iterations")
    @JsonIgnore
    public IterationCollectionRequest getIterations() {
        return new IterationCollectionRequest(
                        contextPath.addSegment("Iterations"), RequestHelper.getValue(unmappedFields, "Iterations"));
    }

    @NavigationProperty(name="Teams")
    @JsonIgnore
    public TeamCollectionRequest getTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("Teams"), RequestHelper.getValue(unmappedFields, "Teams"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Project patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Project _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Project put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Project _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Project _copy() {
        Project _x = new Project();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.projectId = projectId;
        _x.projectName = projectName;
        _x.projectVisibility = projectVisibility;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Project[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("ProjectId=");
        b.append(this.projectId);
        b.append(", ");
        b.append("ProjectName=");
        b.append(this.projectName);
        b.append(", ");
        b.append("ProjectVisibility=");
        b.append(this.projectVisibility);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
