package microsoft.vs.analytics.v2.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.enums.Period;

@JsonPropertyOrder({
    "@odata.type", 
    "Date", 
    "DateSK", 
    "DayName", 
    "DayShortName", 
    "DayOfWeek", 
    "DayOfMonth", 
    "DayOfYear", 
    "WeekStartingDate", 
    "WeekEndingDate", 
    "Month", 
    "MonthName", 
    "MonthShortName", 
    "MonthOfYear", 
    "YearMonth", 
    "Year", 
    "IsLastDayOfPeriod"})
@JsonInclude(Include.NON_NULL)
public class CalendarDate implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Date")
    protected OffsetDateTime date;

    @JsonProperty("DateSK")
    protected Integer dateSK;

    @JsonProperty("DayName")
    protected String dayName;

    @JsonProperty("DayShortName")
    protected String dayShortName;

    @JsonProperty("DayOfWeek")
    protected Integer dayOfWeek;

    @JsonProperty("DayOfMonth")
    protected Integer dayOfMonth;

    @JsonProperty("DayOfYear")
    protected Integer dayOfYear;

    @JsonProperty("WeekStartingDate")
    protected OffsetDateTime weekStartingDate;

    @JsonProperty("WeekEndingDate")
    protected OffsetDateTime weekEndingDate;

    @JsonProperty("Month")
    protected String month;

    @JsonProperty("MonthName")
    protected String monthName;

    @JsonProperty("MonthShortName")
    protected String monthShortName;

    @JsonProperty("MonthOfYear")
    protected Integer monthOfYear;

    @JsonProperty("YearMonth")
    protected Integer yearMonth;

    @JsonProperty("Year")
    protected Integer year;

    @JsonProperty("IsLastDayOfPeriod")
    protected Period isLastDayOfPeriod;

    protected CalendarDate() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime date;
        private Integer dateSK;
        private String dayName;
        private String dayShortName;
        private Integer dayOfWeek;
        private Integer dayOfMonth;
        private Integer dayOfYear;
        private OffsetDateTime weekStartingDate;
        private OffsetDateTime weekEndingDate;
        private String month;
        private String monthName;
        private String monthShortName;
        private Integer monthOfYear;
        private Integer yearMonth;
        private Integer year;
        private Period isLastDayOfPeriod;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder date(OffsetDateTime date) {
            this.date = date;
            this.changedFields = changedFields.add("Date");
            return this;
        }

        public Builder dateSK(Integer dateSK) {
            this.dateSK = dateSK;
            this.changedFields = changedFields.add("DateSK");
            return this;
        }

        public Builder dayName(String dayName) {
            this.dayName = dayName;
            this.changedFields = changedFields.add("DayName");
            return this;
        }

        public Builder dayShortName(String dayShortName) {
            this.dayShortName = dayShortName;
            this.changedFields = changedFields.add("DayShortName");
            return this;
        }

        public Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.changedFields = changedFields.add("DayOfWeek");
            return this;
        }

        public Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            this.changedFields = changedFields.add("DayOfMonth");
            return this;
        }

        public Builder dayOfYear(Integer dayOfYear) {
            this.dayOfYear = dayOfYear;
            this.changedFields = changedFields.add("DayOfYear");
            return this;
        }

        public Builder weekStartingDate(OffsetDateTime weekStartingDate) {
            this.weekStartingDate = weekStartingDate;
            this.changedFields = changedFields.add("WeekStartingDate");
            return this;
        }

        public Builder weekEndingDate(OffsetDateTime weekEndingDate) {
            this.weekEndingDate = weekEndingDate;
            this.changedFields = changedFields.add("WeekEndingDate");
            return this;
        }

        public Builder month(String month) {
            this.month = month;
            this.changedFields = changedFields.add("Month");
            return this;
        }

        public Builder monthName(String monthName) {
            this.monthName = monthName;
            this.changedFields = changedFields.add("MonthName");
            return this;
        }

        public Builder monthShortName(String monthShortName) {
            this.monthShortName = monthShortName;
            this.changedFields = changedFields.add("MonthShortName");
            return this;
        }

        public Builder monthOfYear(Integer monthOfYear) {
            this.monthOfYear = monthOfYear;
            this.changedFields = changedFields.add("MonthOfYear");
            return this;
        }

        public Builder yearMonth(Integer yearMonth) {
            this.yearMonth = yearMonth;
            this.changedFields = changedFields.add("YearMonth");
            return this;
        }

        public Builder year(Integer year) {
            this.year = year;
            this.changedFields = changedFields.add("Year");
            return this;
        }

        public Builder isLastDayOfPeriod(Period isLastDayOfPeriod) {
            this.isLastDayOfPeriod = isLastDayOfPeriod;
            this.changedFields = changedFields.add("IsLastDayOfPeriod");
            return this;
        }

        public CalendarDate build() {
            CalendarDate _x = new CalendarDate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate";
            _x.date = date;
            _x.dateSK = dateSK;
            _x.dayName = dayName;
            _x.dayShortName = dayShortName;
            _x.dayOfWeek = dayOfWeek;
            _x.dayOfMonth = dayOfMonth;
            _x.dayOfYear = dayOfYear;
            _x.weekStartingDate = weekStartingDate;
            _x.weekEndingDate = weekEndingDate;
            _x.month = month;
            _x.monthName = monthName;
            _x.monthShortName = monthShortName;
            _x.monthOfYear = monthOfYear;
            _x.yearMonth = yearMonth;
            _x.year = year;
            _x.isLastDayOfPeriod = isLastDayOfPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && dateSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(dateSK.toString()));
        }
    }

    @Property(name="Date")
    @JsonIgnore
    public Optional<OffsetDateTime> getDate() {
        return Optional.ofNullable(date);
    }

    public CalendarDate withDate(OffsetDateTime date) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("Date");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.date = date;
        return _x;
    }

    @Property(name="DateSK")
    @JsonIgnore
    public Optional<Integer> getDateSK() {
        return Optional.ofNullable(dateSK);
    }

    public CalendarDate withDateSK(Integer dateSK) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DateSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dateSK = dateSK;
        return _x;
    }

    @Property(name="DayName")
    @JsonIgnore
    public Optional<String> getDayName() {
        return Optional.ofNullable(dayName);
    }

    public CalendarDate withDayName(String dayName) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dayName = dayName;
        return _x;
    }

    @Property(name="DayShortName")
    @JsonIgnore
    public Optional<String> getDayShortName() {
        return Optional.ofNullable(dayShortName);
    }

    public CalendarDate withDayShortName(String dayShortName) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DayShortName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dayShortName = dayShortName;
        return _x;
    }

    @Property(name="DayOfWeek")
    @JsonIgnore
    public Optional<Integer> getDayOfWeek() {
        return Optional.ofNullable(dayOfWeek);
    }

    public CalendarDate withDayOfWeek(Integer dayOfWeek) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DayOfWeek");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dayOfWeek = dayOfWeek;
        return _x;
    }

    @Property(name="DayOfMonth")
    @JsonIgnore
    public Optional<Integer> getDayOfMonth() {
        return Optional.ofNullable(dayOfMonth);
    }

    public CalendarDate withDayOfMonth(Integer dayOfMonth) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DayOfMonth");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dayOfMonth = dayOfMonth;
        return _x;
    }

    @Property(name="DayOfYear")
    @JsonIgnore
    public Optional<Integer> getDayOfYear() {
        return Optional.ofNullable(dayOfYear);
    }

    public CalendarDate withDayOfYear(Integer dayOfYear) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("DayOfYear");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.dayOfYear = dayOfYear;
        return _x;
    }

    @Property(name="WeekStartingDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getWeekStartingDate() {
        return Optional.ofNullable(weekStartingDate);
    }

    public CalendarDate withWeekStartingDate(OffsetDateTime weekStartingDate) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("WeekStartingDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.weekStartingDate = weekStartingDate;
        return _x;
    }

    @Property(name="WeekEndingDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getWeekEndingDate() {
        return Optional.ofNullable(weekEndingDate);
    }

    public CalendarDate withWeekEndingDate(OffsetDateTime weekEndingDate) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("WeekEndingDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.weekEndingDate = weekEndingDate;
        return _x;
    }

    @Property(name="Month")
    @JsonIgnore
    public Optional<String> getMonth() {
        return Optional.ofNullable(month);
    }

    public CalendarDate withMonth(String month) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("Month");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.month = month;
        return _x;
    }

    @Property(name="MonthName")
    @JsonIgnore
    public Optional<String> getMonthName() {
        return Optional.ofNullable(monthName);
    }

    public CalendarDate withMonthName(String monthName) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("MonthName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.monthName = monthName;
        return _x;
    }

    @Property(name="MonthShortName")
    @JsonIgnore
    public Optional<String> getMonthShortName() {
        return Optional.ofNullable(monthShortName);
    }

    public CalendarDate withMonthShortName(String monthShortName) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("MonthShortName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.monthShortName = monthShortName;
        return _x;
    }

    @Property(name="MonthOfYear")
    @JsonIgnore
    public Optional<Integer> getMonthOfYear() {
        return Optional.ofNullable(monthOfYear);
    }

    public CalendarDate withMonthOfYear(Integer monthOfYear) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("MonthOfYear");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.monthOfYear = monthOfYear;
        return _x;
    }

    @Property(name="YearMonth")
    @JsonIgnore
    public Optional<Integer> getYearMonth() {
        return Optional.ofNullable(yearMonth);
    }

    public CalendarDate withYearMonth(Integer yearMonth) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("YearMonth");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.yearMonth = yearMonth;
        return _x;
    }

    @Property(name="Year")
    @JsonIgnore
    public Optional<Integer> getYear() {
        return Optional.ofNullable(year);
    }

    public CalendarDate withYear(Integer year) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("Year");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.year = year;
        return _x;
    }

    @Property(name="IsLastDayOfPeriod")
    @JsonIgnore
    public Optional<Period> getIsLastDayOfPeriod() {
        return Optional.ofNullable(isLastDayOfPeriod);
    }

    public CalendarDate withIsLastDayOfPeriod(Period isLastDayOfPeriod) {
        CalendarDate _x = _copy();
        _x.changedFields = changedFields.add("IsLastDayOfPeriod");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.CalendarDate");
        _x.isLastDayOfPeriod = isLastDayOfPeriod;
        return _x;
    }

    public CalendarDate withUnmappedField(String name, String value) {
        CalendarDate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarDate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CalendarDate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarDate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CalendarDate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CalendarDate _copy() {
        CalendarDate _x = new CalendarDate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.date = date;
        _x.dateSK = dateSK;
        _x.dayName = dayName;
        _x.dayShortName = dayShortName;
        _x.dayOfWeek = dayOfWeek;
        _x.dayOfMonth = dayOfMonth;
        _x.dayOfYear = dayOfYear;
        _x.weekStartingDate = weekStartingDate;
        _x.weekEndingDate = weekEndingDate;
        _x.month = month;
        _x.monthName = monthName;
        _x.monthShortName = monthShortName;
        _x.monthOfYear = monthOfYear;
        _x.yearMonth = yearMonth;
        _x.year = year;
        _x.isLastDayOfPeriod = isLastDayOfPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarDate[");
        b.append("Date=");
        b.append(this.date);
        b.append(", ");
        b.append("DateSK=");
        b.append(this.dateSK);
        b.append(", ");
        b.append("DayName=");
        b.append(this.dayName);
        b.append(", ");
        b.append("DayShortName=");
        b.append(this.dayShortName);
        b.append(", ");
        b.append("DayOfWeek=");
        b.append(this.dayOfWeek);
        b.append(", ");
        b.append("DayOfMonth=");
        b.append(this.dayOfMonth);
        b.append(", ");
        b.append("DayOfYear=");
        b.append(this.dayOfYear);
        b.append(", ");
        b.append("WeekStartingDate=");
        b.append(this.weekStartingDate);
        b.append(", ");
        b.append("WeekEndingDate=");
        b.append(this.weekEndingDate);
        b.append(", ");
        b.append("Month=");
        b.append(this.month);
        b.append(", ");
        b.append("MonthName=");
        b.append(this.monthName);
        b.append(", ");
        b.append("MonthShortName=");
        b.append(this.monthShortName);
        b.append(", ");
        b.append("MonthOfYear=");
        b.append(this.monthOfYear);
        b.append(", ");
        b.append("YearMonth=");
        b.append(this.yearMonth);
        b.append(", ");
        b.append("Year=");
        b.append(this.year);
        b.append(", ");
        b.append("IsLastDayOfPeriod=");
        b.append(this.isLastDayOfPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
